/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFOduSigIdT;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOduSigIdTVer13
implements OFOduSigIdT {
    private static final Logger logger = LoggerFactory.getLogger(OFOduSigIdTVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    private static final int DEFAULT_TPN = 0;
    private static final byte[] DEFAULT_TSMAP = new byte[0];
    private final int tpn;
    private final byte[] tsmap;
    static final OFOduSigIdTVer13 DEFAULT = new OFOduSigIdTVer13(0, DEFAULT_TSMAP);
    static final Reader READER = new Reader();
    static final OFOduSigIdTVer13Funnel FUNNEL = new OFOduSigIdTVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOduSigIdTVer13(int tpn, byte[] tsmap) {
        if (tsmap == null) {
            throw new NullPointerException("OFOduSigIdTVer13: property tsmap cannot be null");
        }
        this.tpn = tpn;
        this.tsmap = tsmap;
    }

    @Override
    public int getTpn() {
        return this.tpn;
    }

    @Override
    public byte[] getTsmap() {
        return this.tsmap;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOduSigIdT.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOduSigIdTVer13(");
        b.append("tpn=").append(this.tpn);
        b.append(", ");
        b.append("tsmap=").append(Arrays.toString(this.tsmap));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOduSigIdTVer13 other = (OFOduSigIdTVer13)obj;
        if (this.tpn != other.tpn) {
            return false;
        }
        return Arrays.equals(this.tsmap, other.tsmap);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.tpn;
        result = 31 * result + Arrays.hashCode(this.tsmap);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOduSigIdTVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOduSigIdTVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(message.tpn));
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeBytes(message.tsmap);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFOduSigIdTVer13Funnel
    implements Funnel<OFOduSigIdTVer13> {
        private static final long serialVersionUID = 1L;

        OFOduSigIdTVer13Funnel() {
        }

        public void funnel(OFOduSigIdTVer13 message, PrimitiveSink sink) {
            sink.putInt(message.tpn);
            sink.putBytes(message.tsmap);
        }
    }

    static class Reader
    implements OFMessageReader<OFOduSigIdT> {
        Reader() {
        }

        @Override
        public OFOduSigIdT readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int tpn = U16.f(bb.readShort());
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            byte[] tsmap = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFOduSigIdTVer13 oduSigIdTVer13 = new OFOduSigIdTVer13(tpn, tsmap);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oduSigIdTVer13);
            }
            return oduSigIdTVer13;
        }
    }

    static class Builder
    implements OFOduSigIdT.Builder {
        private boolean tpnSet;
        private int tpn;
        private boolean tsmapSet;
        private byte[] tsmap;

        Builder() {
        }

        @Override
        public int getTpn() {
            return this.tpn;
        }

        @Override
        public OFOduSigIdT.Builder setTpn(int tpn) {
            this.tpn = tpn;
            this.tpnSet = true;
            return this;
        }

        @Override
        public byte[] getTsmap() {
            return this.tsmap;
        }

        @Override
        public OFOduSigIdT.Builder setTsmap(byte[] tsmap) {
            this.tsmap = tsmap;
            this.tsmapSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOduSigIdT build() {
            byte[] tsmap;
            int tpn = this.tpnSet ? this.tpn : 0;
            byte[] byArray = tsmap = this.tsmapSet ? this.tsmap : DEFAULT_TSMAP;
            if (tsmap == null) {
                throw new NullPointerException("Property tsmap must not be null");
            }
            return new OFOduSigIdTVer13(tpn, tsmap);
        }
    }

    static class BuilderWithParent
    implements OFOduSigIdT.Builder {
        final OFOduSigIdTVer13 parentMessage;
        private boolean tpnSet;
        private int tpn;
        private boolean tsmapSet;
        private byte[] tsmap;

        BuilderWithParent(OFOduSigIdTVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getTpn() {
            return this.tpn;
        }

        @Override
        public OFOduSigIdT.Builder setTpn(int tpn) {
            this.tpn = tpn;
            this.tpnSet = true;
            return this;
        }

        @Override
        public byte[] getTsmap() {
            return this.tsmap;
        }

        @Override
        public OFOduSigIdT.Builder setTsmap(byte[] tsmap) {
            this.tsmap = tsmap;
            this.tsmapSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOduSigIdT build() {
            byte[] tsmap;
            int tpn = this.tpnSet ? this.tpn : this.parentMessage.tpn;
            byte[] byArray = tsmap = this.tsmapSet ? this.tsmap : this.parentMessage.tsmap;
            if (tsmap == null) {
                throw new NullPointerException("Property tsmap must not be null");
            }
            return new OFOduSigIdTVer13(tpn, tsmap);
        }
    }
}

