/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmMetadata;
import org.projectfloodlight.openflow.types.OFMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmMetadataVer13
implements OFOxmMetadata {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmMetadataVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final OFMetadata DEFAULT_VALUE = OFMetadata.NONE;
    private final OFMetadata value;
    static final OFOxmMetadataVer13 DEFAULT = new OFOxmMetadataVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmMetadataVer13Funnel FUNNEL = new OFOxmMetadataVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmMetadataVer13(OFMetadata value) {
        if (value == null) {
            throw new NullPointerException("OFOxmMetadataVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 0x80000408L;
    }

    @Override
    public OFMetadata getValue() {
        return this.value;
    }

    @Override
    public MatchField<OFMetadata> getMatchField() {
        return MatchField.METADATA;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OFMetadata> getCanonical() {
        return this;
    }

    @Override
    public OFMetadata getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmMetadata.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmMetadataVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmMetadataVer13 other = (OFOxmMetadataVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmMetadataVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmMetadataVer13 message) {
            bb.writeInt(-2147482616);
            message.value.write8Bytes(bb);
        }
    }

    static class OFOxmMetadataVer13Funnel
    implements Funnel<OFOxmMetadataVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmMetadataVer13Funnel() {
        }

        public void funnel(OFOxmMetadataVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147482616);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmMetadata> {
        Reader() {
        }

        @Override
        public OFOxmMetadata readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147482616) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000408L(0x80000408L), got=" + typeLen);
            }
            OFMetadata value = OFMetadata.read8Bytes(bb);
            OFOxmMetadataVer13 oxmMetadataVer13 = new OFOxmMetadataVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmMetadataVer13);
            }
            return oxmMetadataVer13;
        }
    }

    static class Builder
    implements OFOxmMetadata.Builder {
        private boolean valueSet;
        private OFMetadata value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 0x80000408L;
        }

        @Override
        public OFMetadata getValue() {
            return this.value;
        }

        @Override
        public OFOxmMetadata.Builder setValue(OFMetadata value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFMetadata> getMatchField() {
            return MatchField.METADATA;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFMetadata> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFMetadata getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmMetadata build() {
            OFMetadata value;
            OFMetadata oFMetadata = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmMetadataVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmMetadata.Builder {
        final OFOxmMetadataVer13 parentMessage;
        private boolean valueSet;
        private OFMetadata value;

        BuilderWithParent(OFOxmMetadataVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 0x80000408L;
        }

        @Override
        public OFMetadata getValue() {
            return this.value;
        }

        @Override
        public OFOxmMetadata.Builder setValue(OFMetadata value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFMetadata> getMatchField() {
            return MatchField.METADATA;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFMetadata> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFMetadata getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmMetadata build() {
            OFMetadata value;
            OFMetadata oFMetadata = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmMetadataVer13(value);
        }
    }
}

