/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOchSigid;
import org.projectfloodlight.openflow.types.CircuitSignalID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmOchSigidVer13
implements OFOxmOchSigid {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmOchSigidVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 10;
    private static final CircuitSignalID DEFAULT_VALUE = CircuitSignalID.NONE;
    private final CircuitSignalID value;
    static final OFOxmOchSigidVer13 DEFAULT = new OFOxmOchSigidVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmOchSigidVer13Funnel FUNNEL = new OFOxmOchSigidVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmOchSigidVer13(CircuitSignalID value) {
        if (value == null) {
            throw new NullPointerException("OFOxmOchSigidVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 547334L;
    }

    @Override
    public CircuitSignalID getValue() {
        return this.value;
    }

    @Override
    public MatchField<CircuitSignalID> getMatchField() {
        return MatchField.OCH_SIGID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<CircuitSignalID> getCanonical() {
        return this;
    }

    @Override
    public CircuitSignalID getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmOchSigid.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmOchSigidVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmOchSigidVer13 other = (OFOxmOchSigidVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmOchSigidVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmOchSigidVer13 message) {
            bb.writeInt(547334);
            message.value.write6Bytes(bb);
        }
    }

    static class OFOxmOchSigidVer13Funnel
    implements Funnel<OFOxmOchSigidVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmOchSigidVer13Funnel() {
        }

        public void funnel(OFOxmOchSigidVer13 message, PrimitiveSink sink) {
            sink.putInt(547334);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmOchSigid> {
        Reader() {
        }

        @Override
        public OFOxmOchSigid readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 547334) {
                throw new OFParseError("Wrong typeLen: Expected=0x85a06L(0x85a06L), got=" + typeLen);
            }
            CircuitSignalID value = CircuitSignalID.read6Bytes(bb);
            OFOxmOchSigidVer13 oxmOchSigidVer13 = new OFOxmOchSigidVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmOchSigidVer13);
            }
            return oxmOchSigidVer13;
        }
    }

    static class Builder
    implements OFOxmOchSigid.Builder {
        private boolean valueSet;
        private CircuitSignalID value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 547334L;
        }

        @Override
        public CircuitSignalID getValue() {
            return this.value;
        }

        @Override
        public OFOxmOchSigid.Builder setValue(CircuitSignalID value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<CircuitSignalID> getMatchField() {
            return MatchField.OCH_SIGID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<CircuitSignalID> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public CircuitSignalID getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmOchSigid build() {
            CircuitSignalID value;
            CircuitSignalID circuitSignalID = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOchSigidVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmOchSigid.Builder {
        final OFOxmOchSigidVer13 parentMessage;
        private boolean valueSet;
        private CircuitSignalID value;

        BuilderWithParent(OFOxmOchSigidVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 547334L;
        }

        @Override
        public CircuitSignalID getValue() {
            return this.value;
        }

        @Override
        public OFOxmOchSigid.Builder setValue(CircuitSignalID value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<CircuitSignalID> getMatchField() {
            return MatchField.OCH_SIGID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<CircuitSignalID> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public CircuitSignalID getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmOchSigid build() {
            CircuitSignalID value;
            CircuitSignalID circuitSignalID = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOchSigidVer13(value);
        }
    }
}

