/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFQueueGetConfigRequest;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueGetConfigRequestVer13
implements OFQueueGetConfigRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueGetConfigRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final OFPort DEFAULT_PORT = OFPort.ANY;
    private final long xid;
    private final OFPort port;
    static final OFQueueGetConfigRequestVer13 DEFAULT = new OFQueueGetConfigRequestVer13(0L, DEFAULT_PORT);
    static final Reader READER = new Reader();
    static final OFQueueGetConfigRequestVer13Funnel FUNNEL = new OFQueueGetConfigRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFQueueGetConfigRequestVer13(long xid, OFPort port) {
        if (port == null) {
            throw new NullPointerException("OFQueueGetConfigRequestVer13: property port cannot be null");
        }
        this.xid = xid;
        this.port = port;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.QUEUE_GET_CONFIG_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFPort getPort() {
        return this.port;
    }

    @Override
    public OFQueueGetConfigRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueGetConfigRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("port=").append(this.port);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueGetConfigRequestVer13 other = (OFQueueGetConfigRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.port == null ? other.port != null : !this.port.equals(other.port));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueGetConfigRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFQueueGetConfigRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(22);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            message.port.write4Bytes(bb);
            bb.writeZero(4);
        }
    }

    static class OFQueueGetConfigRequestVer13Funnel
    implements Funnel<OFQueueGetConfigRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFQueueGetConfigRequestVer13Funnel() {
        }

        public void funnel(OFQueueGetConfigRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)22);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            message.port.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueGetConfigRequest> {
        Reader() {
        }

        @Override
        public OFQueueGetConfigRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 22) {
                throw new OFParseError("Wrong type: Expected=OFType.QUEUE_GET_CONFIG_REQUEST(22), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFPort port = OFPort.read4Bytes(bb);
            bb.skipBytes(4);
            OFQueueGetConfigRequestVer13 queueGetConfigRequestVer13 = new OFQueueGetConfigRequestVer13(xid, port);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueGetConfigRequestVer13);
            }
            return queueGetConfigRequestVer13;
        }
    }

    static class Builder
    implements OFQueueGetConfigRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean portSet;
        private OFPort port;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.QUEUE_GET_CONFIG_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFQueueGetConfigRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFQueueGetConfigRequest.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public OFQueueGetConfigRequest build() {
            OFPort port;
            long xid = this.xidSet ? this.xid : 0L;
            OFPort oFPort = port = this.portSet ? this.port : DEFAULT_PORT;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            return new OFQueueGetConfigRequestVer13(xid, port);
        }
    }

    static class BuilderWithParent
    implements OFQueueGetConfigRequest.Builder {
        final OFQueueGetConfigRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean portSet;
        private OFPort port;

        BuilderWithParent(OFQueueGetConfigRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.QUEUE_GET_CONFIG_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFQueueGetConfigRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFQueueGetConfigRequest.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public OFQueueGetConfigRequest build() {
            OFPort port;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFPort oFPort = port = this.portSet ? this.port : this.parentMessage.port;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            return new OFQueueGetConfigRequestVer13(xid, port);
        }
    }
}

