/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBadPropertyCode;

public class OFBadPropertyCodeSerializerVer14 {
    public static final short BAD_TYPE_VAL = 0;
    public static final short BAD_LEN_VAL = 1;
    public static final short BAD_VALUE_VAL = 2;
    public static final short TOO_MANY_VAL = 3;
    public static final short DUP_TYPE_VAL = 4;
    public static final short BAD_EXPERIMENTER_VAL = 5;
    public static final short BAD_EXP_TYPE_VAL = 6;
    public static final short BAD_EXP_VALUE_VAL = 7;
    public static final short EPERM_VAL = 8;

    public static OFBadPropertyCode readFrom(ChannelBuffer bb) throws OFParseError {
        try {
            return OFBadPropertyCodeSerializerVer14.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ChannelBuffer bb, OFBadPropertyCode e) {
        bb.writeShort((int)OFBadPropertyCodeSerializerVer14.toWireValue(e));
    }

    public static void putTo(OFBadPropertyCode e, PrimitiveSink sink) {
        sink.putShort(OFBadPropertyCodeSerializerVer14.toWireValue(e));
    }

    public static OFBadPropertyCode ofWireValue(short val) {
        switch (val) {
            case 0: {
                return OFBadPropertyCode.BAD_TYPE;
            }
            case 1: {
                return OFBadPropertyCode.BAD_LEN;
            }
            case 2: {
                return OFBadPropertyCode.BAD_VALUE;
            }
            case 3: {
                return OFBadPropertyCode.TOO_MANY;
            }
            case 4: {
                return OFBadPropertyCode.DUP_TYPE;
            }
            case 5: {
                return OFBadPropertyCode.BAD_EXPERIMENTER;
            }
            case 6: {
                return OFBadPropertyCode.BAD_EXP_TYPE;
            }
            case 7: {
                return OFBadPropertyCode.BAD_EXP_VALUE;
            }
            case 8: {
                return OFBadPropertyCode.EPERM;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFBadPropertyCode in version 1.4: " + val);
    }

    public static short toWireValue(OFBadPropertyCode e) {
        switch (e) {
            case BAD_TYPE: {
                return 0;
            }
            case BAD_LEN: {
                return 1;
            }
            case BAD_VALUE: {
                return 2;
            }
            case TOO_MANY: {
                return 3;
            }
            case DUP_TYPE: {
                return 4;
            }
            case BAD_EXPERIMENTER: {
                return 5;
            }
            case BAD_EXP_TYPE: {
                return 6;
            }
            case BAD_EXP_VALUE: {
                return 7;
            }
            case EPERM: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFBadPropertyCode in version 1.4: " + (Object)((Object)e));
    }
}

