/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvExternalGatewayIp;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvExternalGatewayIpVer14
implements OFBsnTlvExternalGatewayIp {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvExternalGatewayIpVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFBsnTlvExternalGatewayIpVer14 DEFAULT = new OFBsnTlvExternalGatewayIpVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvExternalGatewayIpVer14Funnel FUNNEL = new OFBsnTlvExternalGatewayIpVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvExternalGatewayIpVer14(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvExternalGatewayIpVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 26;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvExternalGatewayIp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvExternalGatewayIpVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvExternalGatewayIpVer14 other = (OFBsnTlvExternalGatewayIpVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvExternalGatewayIpVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvExternalGatewayIpVer14 message) {
            bb.writeShort(26);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvExternalGatewayIpVer14Funnel
    implements Funnel<OFBsnTlvExternalGatewayIpVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvExternalGatewayIpVer14Funnel() {
        }

        public void funnel(OFBsnTlvExternalGatewayIpVer14 message, PrimitiveSink sink) {
            sink.putShort((short)26);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvExternalGatewayIp> {
        Reader() {
        }

        @Override
        public OFBsnTlvExternalGatewayIp readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 26) {
                throw new OFParseError("Wrong type: Expected=0x1a(0x1a), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFBsnTlvExternalGatewayIpVer14 bsnTlvExternalGatewayIpVer14 = new OFBsnTlvExternalGatewayIpVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvExternalGatewayIpVer14);
            }
            return bsnTlvExternalGatewayIpVer14;
        }
    }

    static class Builder
    implements OFBsnTlvExternalGatewayIp.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 26;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvExternalGatewayIp.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvExternalGatewayIp build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvExternalGatewayIpVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvExternalGatewayIp.Builder {
        final OFBsnTlvExternalGatewayIpVer14 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFBsnTlvExternalGatewayIpVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 26;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvExternalGatewayIp.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvExternalGatewayIp build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvExternalGatewayIpVer14(value);
        }
    }
}

