/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPartnerSystemMac;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPartnerSystemMacVer14
implements OFBsnTlvPartnerSystemMac {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPartnerSystemMacVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFBsnTlvPartnerSystemMacVer14 DEFAULT = new OFBsnTlvPartnerSystemMacVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvPartnerSystemMacVer14Funnel FUNNEL = new OFBsnTlvPartnerSystemMacVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPartnerSystemMacVer14(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPartnerSystemMacVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 48;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvPartnerSystemMac.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPartnerSystemMacVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPartnerSystemMacVer14 other = (OFBsnTlvPartnerSystemMacVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPartnerSystemMacVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvPartnerSystemMacVer14 message) {
            bb.writeShort(48);
            bb.writeShort(10);
            message.value.write6Bytes(bb);
        }
    }

    static class OFBsnTlvPartnerSystemMacVer14Funnel
    implements Funnel<OFBsnTlvPartnerSystemMacVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPartnerSystemMacVer14Funnel() {
        }

        public void funnel(OFBsnTlvPartnerSystemMacVer14 message, PrimitiveSink sink) {
            sink.putShort((short)48);
            sink.putShort((short)10);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPartnerSystemMac> {
        Reader() {
        }

        @Override
        public OFBsnTlvPartnerSystemMac readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 48) {
                throw new OFParseError("Wrong type: Expected=0x30(0x30), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFBsnTlvPartnerSystemMacVer14 bsnTlvPartnerSystemMacVer14 = new OFBsnTlvPartnerSystemMacVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPartnerSystemMacVer14);
            }
            return bsnTlvPartnerSystemMacVer14;
        }
    }

    static class Builder
    implements OFBsnTlvPartnerSystemMac.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public int getType() {
            return 48;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerSystemMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvPartnerSystemMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPartnerSystemMacVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPartnerSystemMac.Builder {
        final OFBsnTlvPartnerSystemMacVer14 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFBsnTlvPartnerSystemMacVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 48;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerSystemMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvPartnerSystemMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPartnerSystemMacVer14(value);
        }
    }
}

