/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvQueueId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvQueueIdVer14
implements OFBsnTlvQueueId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvQueueIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvQueueIdVer14 DEFAULT = new OFBsnTlvQueueIdVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvQueueIdVer14Funnel FUNNEL = new OFBsnTlvQueueIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvQueueIdVer14(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 20;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvQueueId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvQueueIdVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvQueueIdVer14 other = (OFBsnTlvQueueIdVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvQueueIdVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvQueueIdVer14 message) {
            bb.writeShort(20);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvQueueIdVer14Funnel
    implements Funnel<OFBsnTlvQueueIdVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvQueueIdVer14Funnel() {
        }

        public void funnel(OFBsnTlvQueueIdVer14 message, PrimitiveSink sink) {
            sink.putShort((short)20);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvQueueId> {
        Reader() {
        }

        @Override
        public OFBsnTlvQueueId readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 20) {
                throw new OFParseError("Wrong type: Expected=0x14(0x14), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvQueueIdVer14 bsnTlvQueueIdVer14 = new OFBsnTlvQueueIdVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvQueueIdVer14);
            }
            return bsnTlvQueueIdVer14;
        }
    }

    static class Builder
    implements OFBsnTlvQueueId.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 20;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvQueueId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvQueueId build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvQueueIdVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvQueueId.Builder {
        final OFBsnTlvQueueIdVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvQueueIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 20;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvQueueId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvQueueId build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvQueueIdVer14(value);
        }
    }
}

