/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUdpSrc;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUdpSrcVer14
implements OFBsnTlvUdpSrc {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUdpSrcVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvUdpSrcVer14 DEFAULT = new OFBsnTlvUdpSrcVer14(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvUdpSrcVer14Funnel FUNNEL = new OFBsnTlvUdpSrcVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUdpSrcVer14(int value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 36;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvUdpSrc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUdpSrcVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUdpSrcVer14 other = (OFBsnTlvUdpSrcVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUdpSrcVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvUdpSrcVer14 message) {
            bb.writeShort(36);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvUdpSrcVer14Funnel
    implements Funnel<OFBsnTlvUdpSrcVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUdpSrcVer14Funnel() {
        }

        public void funnel(OFBsnTlvUdpSrcVer14 message, PrimitiveSink sink) {
            sink.putShort((short)36);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUdpSrc> {
        Reader() {
        }

        @Override
        public OFBsnTlvUdpSrc readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 36) {
                throw new OFParseError("Wrong type: Expected=0x24(0x24), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvUdpSrcVer14 bsnTlvUdpSrcVer14 = new OFBsnTlvUdpSrcVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUdpSrcVer14);
            }
            return bsnTlvUdpSrcVer14;
        }
    }

    static class Builder
    implements OFBsnTlvUdpSrc.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 36;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdpSrc.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUdpSrc build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvUdpSrcVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUdpSrc.Builder {
        final OFBsnTlvUdpSrcVer14 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvUdpSrcVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 36;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdpSrc.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUdpSrc build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvUdpSrcVer14(value);
        }
    }
}

