/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUnicastQueryTimeout;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUnicastQueryTimeoutVer14
implements OFBsnTlvUnicastQueryTimeout {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUnicastQueryTimeoutVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvUnicastQueryTimeoutVer14 DEFAULT = new OFBsnTlvUnicastQueryTimeoutVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvUnicastQueryTimeoutVer14Funnel FUNNEL = new OFBsnTlvUnicastQueryTimeoutVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUnicastQueryTimeoutVer14(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvUnicastQueryTimeout.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUnicastQueryTimeoutVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUnicastQueryTimeoutVer14 other = (OFBsnTlvUnicastQueryTimeoutVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUnicastQueryTimeoutVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvUnicastQueryTimeoutVer14 message) {
            bb.writeShort(9);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvUnicastQueryTimeoutVer14Funnel
    implements Funnel<OFBsnTlvUnicastQueryTimeoutVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUnicastQueryTimeoutVer14Funnel() {
        }

        public void funnel(OFBsnTlvUnicastQueryTimeoutVer14 message, PrimitiveSink sink) {
            sink.putShort((short)9);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUnicastQueryTimeout> {
        Reader() {
        }

        @Override
        public OFBsnTlvUnicastQueryTimeout readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 9) {
                throw new OFParseError("Wrong type: Expected=0x9(0x9), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvUnicastQueryTimeoutVer14 bsnTlvUnicastQueryTimeoutVer14 = new OFBsnTlvUnicastQueryTimeoutVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUnicastQueryTimeoutVer14);
            }
            return bsnTlvUnicastQueryTimeoutVer14;
        }
    }

    static class Builder
    implements OFBsnTlvUnicastQueryTimeout.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 9;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUnicastQueryTimeout.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUnicastQueryTimeout build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvUnicastQueryTimeoutVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUnicastQueryTimeout.Builder {
        final OFBsnTlvUnicastQueryTimeoutVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvUnicastQueryTimeoutVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 9;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUnicastQueryTimeout.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUnicastQueryTimeout build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvUnicastQueryTimeoutVer14(value);
        }
    }
}

