/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBundleCtrlMsg;
import org.projectfloodlight.openflow.protocol.OFBundleCtrlType;
import org.projectfloodlight.openflow.protocol.OFBundleFlags;
import org.projectfloodlight.openflow.protocol.OFBundleProp;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFBundleCtrlTypeSerializerVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBundleFlagsSerializerVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBundlePropVer14;
import org.projectfloodlight.openflow.types.BundleId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBundleCtrlMsgVer14
implements OFBundleCtrlMsg {
    private static final Logger logger = LoggerFactory.getLogger(OFBundleCtrlMsgVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFBundleFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFBundleProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final BundleId bundleId;
    private final OFBundleCtrlType bundleCtrlType;
    private final Set<OFBundleFlags> flags;
    private final List<OFBundleProp> properties;
    static final Reader READER = new Reader();
    static final OFBundleCtrlMsgVer14Funnel FUNNEL = new OFBundleCtrlMsgVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBundleCtrlMsgVer14(long xid, BundleId bundleId, OFBundleCtrlType bundleCtrlType, Set<OFBundleFlags> flags, List<OFBundleProp> properties) {
        if (bundleId == null) {
            throw new NullPointerException("OFBundleCtrlMsgVer14: property bundleId cannot be null");
        }
        if (bundleCtrlType == null) {
            throw new NullPointerException("OFBundleCtrlMsgVer14: property bundleCtrlType cannot be null");
        }
        if (flags == null) {
            throw new NullPointerException("OFBundleCtrlMsgVer14: property flags cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFBundleCtrlMsgVer14: property properties cannot be null");
        }
        this.xid = xid;
        this.bundleId = bundleId;
        this.bundleCtrlType = bundleCtrlType;
        this.flags = flags;
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.BUNDLE_CONTROL;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public BundleId getBundleId() {
        return this.bundleId;
    }

    @Override
    public OFBundleCtrlType getBundleCtrlType() {
        return this.bundleCtrlType;
    }

    @Override
    public Set<OFBundleFlags> getFlags() {
        return this.flags;
    }

    @Override
    public List<OFBundleProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFBundleCtrlMsg.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBundleCtrlMsgVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("bundleId=").append(this.bundleId);
        b.append(", ");
        b.append("bundleCtrlType=").append((Object)this.bundleCtrlType);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleCtrlMsgVer14 other = (OFBundleCtrlMsgVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
            return false;
        }
        if (this.bundleCtrlType == null ? other.bundleCtrlType != null : !this.bundleCtrlType.equals((Object)other.bundleCtrlType)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
        result = 31 * result + (this.bundleCtrlType == null ? 0 : this.bundleCtrlType.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBundleCtrlMsgVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBundleCtrlMsgVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(5);
            bb.writeByte(33);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.bundleId.write4Bytes(bb);
            OFBundleCtrlTypeSerializerVer14.writeTo(bb, message.bundleCtrlType);
            OFBundleFlagsSerializerVer14.writeTo(bb, message.flags);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBundleCtrlMsgVer14Funnel
    implements Funnel<OFBundleCtrlMsgVer14> {
        private static final long serialVersionUID = 1L;

        OFBundleCtrlMsgVer14Funnel() {
        }

        public void funnel(OFBundleCtrlMsgVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)33);
            sink.putLong(message.xid);
            message.bundleId.putTo(sink);
            OFBundleCtrlTypeSerializerVer14.putTo(message.bundleCtrlType, sink);
            OFBundleFlagsSerializerVer14.putTo(message.flags, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBundleCtrlMsg> {
        Reader() {
        }

        @Override
        public OFBundleCtrlMsg readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 33) {
                throw new OFParseError("Wrong type: Expected=OFType.BUNDLE_CONTROL(33), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            BundleId bundleId = BundleId.read4Bytes(bb);
            OFBundleCtrlType bundleCtrlType = OFBundleCtrlTypeSerializerVer14.readFrom(bb);
            Set<OFBundleFlags> flags = OFBundleFlagsSerializerVer14.readFrom(bb);
            List<OFBundleProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBundlePropVer14.READER);
            OFBundleCtrlMsgVer14 bundleCtrlMsgVer14 = new OFBundleCtrlMsgVer14(xid, bundleId, bundleCtrlType, flags, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bundleCtrlMsgVer14);
            }
            return bundleCtrlMsgVer14;
        }
    }

    static class Builder
    implements OFBundleCtrlMsg.Builder {
        private boolean xidSet;
        private long xid;
        private boolean bundleIdSet;
        private BundleId bundleId;
        private boolean bundleCtrlTypeSet;
        private OFBundleCtrlType bundleCtrlType;
        private boolean flagsSet;
        private Set<OFBundleFlags> flags;
        private boolean propertiesSet;
        private List<OFBundleProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.BUNDLE_CONTROL;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleCtrlMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public BundleId getBundleId() {
            return this.bundleId;
        }

        @Override
        public OFBundleCtrlMsg.Builder setBundleId(BundleId bundleId) {
            this.bundleId = bundleId;
            this.bundleIdSet = true;
            return this;
        }

        @Override
        public OFBundleCtrlType getBundleCtrlType() {
            return this.bundleCtrlType;
        }

        @Override
        public OFBundleCtrlMsg.Builder setBundleCtrlType(OFBundleCtrlType bundleCtrlType) {
            this.bundleCtrlType = bundleCtrlType;
            this.bundleCtrlTypeSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleCtrlMsg.Builder setFlags(Set<OFBundleFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFBundleProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBundleCtrlMsg.Builder setProperties(List<OFBundleProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFBundleCtrlMsg build() {
            List<OFBundleProp> properties;
            Set<OFBundleFlags> flags;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.bundleIdSet) {
                throw new IllegalStateException("Property bundleId doesn't have default value -- must be set");
            }
            if (this.bundleId == null) {
                throw new NullPointerException("Property bundleId must not be null");
            }
            if (!this.bundleCtrlTypeSet) {
                throw new IllegalStateException("Property bundleCtrlType doesn't have default value -- must be set");
            }
            if (this.bundleCtrlType == null) {
                throw new NullPointerException("Property bundleCtrlType must not be null");
            }
            Set<OFBundleFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List<OFBundleProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBundleCtrlMsgVer14(xid, this.bundleId, this.bundleCtrlType, flags, properties);
        }
    }

    static class BuilderWithParent
    implements OFBundleCtrlMsg.Builder {
        final OFBundleCtrlMsgVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean bundleIdSet;
        private BundleId bundleId;
        private boolean bundleCtrlTypeSet;
        private OFBundleCtrlType bundleCtrlType;
        private boolean flagsSet;
        private Set<OFBundleFlags> flags;
        private boolean propertiesSet;
        private List<OFBundleProp> properties;

        BuilderWithParent(OFBundleCtrlMsgVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.BUNDLE_CONTROL;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleCtrlMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public BundleId getBundleId() {
            return this.bundleId;
        }

        @Override
        public OFBundleCtrlMsg.Builder setBundleId(BundleId bundleId) {
            this.bundleId = bundleId;
            this.bundleIdSet = true;
            return this;
        }

        @Override
        public OFBundleCtrlType getBundleCtrlType() {
            return this.bundleCtrlType;
        }

        @Override
        public OFBundleCtrlMsg.Builder setBundleCtrlType(OFBundleCtrlType bundleCtrlType) {
            this.bundleCtrlType = bundleCtrlType;
            this.bundleCtrlTypeSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleCtrlMsg.Builder setFlags(Set<OFBundleFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFBundleProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBundleCtrlMsg.Builder setProperties(List<OFBundleProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFBundleCtrlMsg build() {
            List properties;
            Set flags;
            OFBundleCtrlType bundleCtrlType;
            BundleId bundleId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            BundleId bundleId2 = bundleId = this.bundleIdSet ? this.bundleId : this.parentMessage.bundleId;
            if (bundleId == null) {
                throw new NullPointerException("Property bundleId must not be null");
            }
            OFBundleCtrlType oFBundleCtrlType = bundleCtrlType = this.bundleCtrlTypeSet ? this.bundleCtrlType : this.parentMessage.bundleCtrlType;
            if (bundleCtrlType == null) {
                throw new NullPointerException("Property bundleCtrlType must not be null");
            }
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBundleCtrlMsgVer14(xid, bundleId, bundleCtrlType, flags, properties);
        }
    }
}

