/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFGroupMod;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupAddVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupDeleteVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupModifyVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFGroupModVer14 {
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFGroupModVer14() {
    }

    static class Reader
    implements OFMessageReader<OFGroupMod> {
        Reader() {
        }

        @Override
        public OFGroupMod readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 15) {
                throw new OFParseError("Wrong type: Expected=OFType.GROUP_MOD(15), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short command = bb.readShort();
            bb.readerIndex(start);
            switch (command) {
                case 0: {
                    return OFGroupAddVer14.READER.readFrom(bb);
                }
                case 2: {
                    return OFGroupDeleteVer14.READER.readFrom(bb);
                }
                case 1: {
                    return OFGroupModifyVer14.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator command of class OFGroupModVer14: " + command);
        }
    }
}

