/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionBsnAutoNegotiation;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionBsnAutoNegotiationVer14
implements OFInstructionBsnAutoNegotiation {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionBsnAutoNegotiationVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    static final OFInstructionBsnAutoNegotiationVer14 DEFAULT = new OFInstructionBsnAutoNegotiationVer14();
    static final OFInstructionBsnAutoNegotiationVer14 INSTANCE = new OFInstructionBsnAutoNegotiationVer14();
    static final Reader READER = new Reader();
    static final OFInstructionBsnAutoNegotiationVer14Funnel FUNNEL = new OFInstructionBsnAutoNegotiationVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFInstructionBsnAutoNegotiationVer14() {
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 11L;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFInstructionBsnAutoNegotiation.Builder createBuilder() {
        throw new UnsupportedOperationException("OFInstructionBsnAutoNegotiationVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionBsnAutoNegotiationVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionBsnAutoNegotiationVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFInstructionBsnAutoNegotiationVer14 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(6035143);
            bb.writeInt(11);
            bb.writeZero(4);
        }
    }

    static class OFInstructionBsnAutoNegotiationVer14Funnel
    implements Funnel<OFInstructionBsnAutoNegotiationVer14> {
        private static final long serialVersionUID = 1L;

        OFInstructionBsnAutoNegotiationVer14Funnel() {
        }

        public void funnel(OFInstructionBsnAutoNegotiationVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(6035143);
            sink.putInt(11);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionBsnAutoNegotiation> {
        Reader() {
        }

        @Override
        public OFInstructionBsnAutoNegotiation readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 11) {
                throw new OFParseError("Wrong subtype: Expected=0xbL(0xbL), got=" + subtype);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

