/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFMeterMod;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.meterband.OFMeterBand;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterBandVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterModVer14
implements OFMeterMod {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterModVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final int DEFAULT_COMMAND = 0;
    private static final int DEFAULT_FLAGS = 0;
    private static final long DEFAULT_METER_ID = 0L;
    private static final List<OFMeterBand> DEFAULT_BANDS = ImmutableList.of();
    private final long xid;
    private final int command;
    private final int flags;
    private final long meterId;
    private final List<OFMeterBand> bands;
    static final OFMeterModVer14 DEFAULT = new OFMeterModVer14(0L, 0, 0, 0L, DEFAULT_BANDS);
    static final Reader READER = new Reader();
    static final OFMeterModVer14Funnel FUNNEL = new OFMeterModVer14Funnel();
    static final Writer WRITER = new Writer();

    OFMeterModVer14(long xid, int command, int flags, long meterId, List<OFMeterBand> bands) {
        if (bands == null) {
            throw new NullPointerException("OFMeterModVer14: property bands cannot be null");
        }
        this.xid = xid;
        this.command = command;
        this.flags = flags;
        this.meterId = meterId;
        this.bands = bands;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.METER_MOD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public int getCommand() {
        return this.command;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public long getMeterId() {
        return this.meterId;
    }

    @Override
    public List<OFMeterBand> getMeters() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property meters not supported in version 1.4");
    }

    @Override
    public List<OFMeterBand> getBands() {
        return this.bands;
    }

    @Override
    public OFMeterMod.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterModVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("command=").append(this.command);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("meterId=").append(this.meterId);
        b.append(", ");
        b.append("bands=").append(this.bands);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterModVer14 other = (OFMeterModVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.command != other.command) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.meterId != other.meterId) {
            return false;
        }
        return !(this.bands == null ? other.bands != null : !this.bands.equals(other.bands));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.command;
        result = 31 * result + this.flags;
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        result = 31 * result + (this.bands == null ? 0 : this.bands.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterModVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFMeterModVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(5);
            bb.writeByte(29);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort((int)U16.t(message.command));
            bb.writeShort((int)U16.t(message.flags));
            bb.writeInt(U32.t(message.meterId));
            ChannelUtils.writeList(bb, message.bands);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFMeterModVer14Funnel
    implements Funnel<OFMeterModVer14> {
        private static final long serialVersionUID = 1L;

        OFMeterModVer14Funnel() {
        }

        public void funnel(OFMeterModVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)29);
            sink.putLong(message.xid);
            sink.putInt(message.command);
            sink.putInt(message.flags);
            sink.putLong(message.meterId);
            FunnelUtils.putList(message.bands, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterMod> {
        Reader() {
        }

        @Override
        public OFMeterMod readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 29) {
                throw new OFParseError("Wrong type: Expected=OFType.METER_MOD(29), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int command = U16.f(bb.readShort());
            int flags = U16.f(bb.readShort());
            long meterId = U32.f(bb.readInt());
            List<OFMeterBand> bands = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFMeterBandVer14.READER);
            OFMeterModVer14 meterModVer14 = new OFMeterModVer14(xid, command, flags, meterId, bands);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterModVer14);
            }
            return meterModVer14;
        }
    }

    static class Builder
    implements OFMeterMod.Builder {
        private boolean xidSet;
        private long xid;
        private boolean commandSet;
        private int command;
        private boolean flagsSet;
        private int flags;
        private boolean meterIdSet;
        private long meterId;
        private boolean bandsSet;
        private List<OFMeterBand> bands;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.METER_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public int getCommand() {
            return this.command;
        }

        @Override
        public OFMeterMod.Builder setCommand(int command) {
            this.command = command;
            this.commandSet = true;
            return this;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterMod.Builder setFlags(int flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterMod.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public List<OFMeterBand> getMeters() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property meters not supported in version 1.4");
        }

        @Override
        public OFMeterMod.Builder setMeters(List<OFMeterBand> meters) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property meters not supported in version 1.4");
        }

        @Override
        public List<OFMeterBand> getBands() {
            return this.bands;
        }

        @Override
        public OFMeterMod.Builder setBands(List<OFMeterBand> bands) {
            this.bands = bands;
            this.bandsSet = true;
            return this;
        }

        @Override
        public OFMeterMod build() {
            List<OFMeterBand> bands;
            long xid = this.xidSet ? this.xid : 0L;
            int command = this.commandSet ? this.command : 0;
            int flags = this.flagsSet ? this.flags : 0;
            long meterId = this.meterIdSet ? this.meterId : 0L;
            List<OFMeterBand> list = bands = this.bandsSet ? this.bands : DEFAULT_BANDS;
            if (bands == null) {
                throw new NullPointerException("Property bands must not be null");
            }
            return new OFMeterModVer14(xid, command, flags, meterId, bands);
        }
    }

    static class BuilderWithParent
    implements OFMeterMod.Builder {
        final OFMeterModVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean commandSet;
        private int command;
        private boolean flagsSet;
        private int flags;
        private boolean meterIdSet;
        private long meterId;
        private boolean bandsSet;
        private List<OFMeterBand> bands;

        BuilderWithParent(OFMeterModVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.METER_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public int getCommand() {
            return this.command;
        }

        @Override
        public OFMeterMod.Builder setCommand(int command) {
            this.command = command;
            this.commandSet = true;
            return this;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterMod.Builder setFlags(int flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterMod.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public List<OFMeterBand> getMeters() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property meters not supported in version 1.4");
        }

        @Override
        public OFMeterMod.Builder setMeters(List<OFMeterBand> meters) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property meters not supported in version 1.4");
        }

        @Override
        public List<OFMeterBand> getBands() {
            return this.bands;
        }

        @Override
        public OFMeterMod.Builder setBands(List<OFMeterBand> bands) {
            this.bands = bands;
            this.bandsSet = true;
            return this;
        }

        @Override
        public OFMeterMod build() {
            List bands;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            int command = this.commandSet ? this.command : this.parentMessage.command;
            int flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            long meterId = this.meterIdSet ? this.meterId : this.parentMessage.meterId;
            List list = bands = this.bandsSet ? this.bands : this.parentMessage.bands;
            if (bands == null) {
                throw new NullPointerException("Property bands must not be null");
            }
            return new OFMeterModVer14(xid, command, flags, meterId, bands);
        }
    }
}

