/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmArpTha;
import org.projectfloodlight.openflow.types.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmArpThaVer14
implements OFOxmArpTha {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmArpThaVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFOxmArpThaVer14 DEFAULT = new OFOxmArpThaVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmArpThaVer14Funnel FUNNEL = new OFOxmArpThaVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmArpThaVer14(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFOxmArpThaVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147496454L;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public MatchField<MacAddress> getMatchField() {
        return MatchField.ARP_THA;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<MacAddress> getCanonical() {
        return this;
    }

    @Override
    public MacAddress getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmArpTha.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmArpThaVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmArpThaVer14 other = (OFOxmArpThaVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmArpThaVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmArpThaVer14 message) {
            bb.writeInt(-2147470842);
            message.value.write6Bytes(bb);
        }
    }

    static class OFOxmArpThaVer14Funnel
    implements Funnel<OFOxmArpThaVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmArpThaVer14Funnel() {
        }

        public void funnel(OFOxmArpThaVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147470842);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmArpTha> {
        Reader() {
        }

        @Override
        public OFOxmArpTha readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147470842) {
                throw new OFParseError("Wrong typeLen: Expected=0x80003206L(0x80003206L), got=" + typeLen);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFOxmArpThaVer14 oxmArpThaVer14 = new OFOxmArpThaVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmArpThaVer14);
            }
            return oxmArpThaVer14;
        }
    }

    static class Builder
    implements OFOxmArpTha.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147496454L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpTha.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ARP_THA;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmArpTha build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmArpThaVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmArpTha.Builder {
        final OFOxmArpThaVer14 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFOxmArpThaVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147496454L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpTha.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ARP_THA;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmArpTha build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmArpThaVer14(value);
        }
    }
}

