/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnInPorts128;
import org.projectfloodlight.openflow.types.OFBitMask128;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnInPorts128Ver14
implements OFOxmBsnInPorts128 {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnInPorts128Ver14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 20;
    private static final OFBitMask128 DEFAULT_VALUE = OFBitMask128.NONE;
    private final OFBitMask128 value;
    static final OFOxmBsnInPorts128Ver14 DEFAULT = new OFOxmBsnInPorts128Ver14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnInPorts128Ver14Funnel FUNNEL = new OFOxmBsnInPorts128Ver14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnInPorts128Ver14(OFBitMask128 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnInPorts128Ver14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 196624L;
    }

    @Override
    public OFBitMask128 getValue() {
        return this.value;
    }

    @Override
    public MatchField<OFBitMask128> getMatchField() {
        return MatchField.BSN_IN_PORTS_128;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OFBitMask128> getCanonical() {
        return this;
    }

    @Override
    public OFBitMask128 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmBsnInPorts128.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnInPorts128Ver14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnInPorts128Ver14 other = (OFOxmBsnInPorts128Ver14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnInPorts128Ver14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmBsnInPorts128Ver14 message) {
            bb.writeInt(196624);
            message.value.write16Bytes(bb);
        }
    }

    static class OFOxmBsnInPorts128Ver14Funnel
    implements Funnel<OFOxmBsnInPorts128Ver14> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnInPorts128Ver14Funnel() {
        }

        public void funnel(OFOxmBsnInPorts128Ver14 message, PrimitiveSink sink) {
            sink.putInt(196624);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnInPorts128> {
        Reader() {
        }

        @Override
        public OFOxmBsnInPorts128 readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 196624) {
                throw new OFParseError("Wrong typeLen: Expected=0x30010L(0x30010L), got=" + typeLen);
            }
            OFBitMask128 value = OFBitMask128.read16Bytes(bb);
            OFOxmBsnInPorts128Ver14 oxmBsnInPorts128Ver14 = new OFOxmBsnInPorts128Ver14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnInPorts128Ver14);
            }
            return oxmBsnInPorts128Ver14;
        }
    }

    static class Builder
    implements OFOxmBsnInPorts128.Builder {
        private boolean valueSet;
        private OFBitMask128 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 196624L;
        }

        @Override
        public OFBitMask128 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInPorts128.Builder setValue(OFBitMask128 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFBitMask128> getMatchField() {
            return MatchField.BSN_IN_PORTS_128;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFBitMask128> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFBitMask128 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnInPorts128 build() {
            OFBitMask128 value;
            OFBitMask128 oFBitMask128 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnInPorts128Ver14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnInPorts128.Builder {
        final OFOxmBsnInPorts128Ver14 parentMessage;
        private boolean valueSet;
        private OFBitMask128 value;

        BuilderWithParent(OFOxmBsnInPorts128Ver14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 196624L;
        }

        @Override
        public OFBitMask128 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInPorts128.Builder setValue(OFBitMask128 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFBitMask128> getMatchField() {
            return MatchField.BSN_IN_PORTS_128;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFBitMask128> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFBitMask128 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnInPorts128 build() {
            OFBitMask128 value;
            OFBitMask128 oFBitMask128 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnInPorts128Ver14(value);
        }
    }
}

