/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEthType;
import org.projectfloodlight.openflow.types.EthType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmEthTypeVer14
implements OFOxmEthType {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmEthTypeVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final EthType DEFAULT_VALUE = EthType.NONE;
    private final EthType value;
    static final OFOxmEthTypeVer14 DEFAULT = new OFOxmEthTypeVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmEthTypeVer14Funnel FUNNEL = new OFOxmEthTypeVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmEthTypeVer14(EthType value) {
        if (value == null) {
            throw new NullPointerException("OFOxmEthTypeVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147486210L;
    }

    @Override
    public EthType getValue() {
        return this.value;
    }

    @Override
    public MatchField<EthType> getMatchField() {
        return MatchField.ETH_TYPE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<EthType> getCanonical() {
        return this;
    }

    @Override
    public EthType getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmEthType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmEthTypeVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmEthTypeVer14 other = (OFOxmEthTypeVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmEthTypeVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmEthTypeVer14 message) {
            bb.writeInt(-2147481086);
            message.value.write2Bytes(bb);
        }
    }

    static class OFOxmEthTypeVer14Funnel
    implements Funnel<OFOxmEthTypeVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmEthTypeVer14Funnel() {
        }

        public void funnel(OFOxmEthTypeVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147481086);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmEthType> {
        Reader() {
        }

        @Override
        public OFOxmEthType readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147481086) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000a02L(0x80000a02L), got=" + typeLen);
            }
            EthType value = EthType.read2Bytes(bb);
            OFOxmEthTypeVer14 oxmEthTypeVer14 = new OFOxmEthTypeVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmEthTypeVer14);
            }
            return oxmEthTypeVer14;
        }
    }

    static class Builder
    implements OFOxmEthType.Builder {
        private boolean valueSet;
        private EthType value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147486210L;
        }

        @Override
        public EthType getValue() {
            return this.value;
        }

        @Override
        public OFOxmEthType.Builder setValue(EthType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<EthType> getMatchField() {
            return MatchField.ETH_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<EthType> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public EthType getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmEthType build() {
            EthType value;
            EthType ethType = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmEthTypeVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmEthType.Builder {
        final OFOxmEthTypeVer14 parentMessage;
        private boolean valueSet;
        private EthType value;

        BuilderWithParent(OFOxmEthTypeVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147486210L;
        }

        @Override
        public EthType getValue() {
            return this.value;
        }

        @Override
        public OFOxmEthType.Builder setValue(EthType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<EthType> getMatchField() {
            return MatchField.ETH_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<EthType> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public EthType getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmEthType build() {
            EthType value;
            EthType ethType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmEthTypeVer14(value);
        }
    }
}

