/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFQueueDesc;
import org.projectfloodlight.openflow.protocol.OFQueueDescProp;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFQueueDescPropVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueDescVer14
implements OFQueueDesc {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueDescVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_PORT_NO = 0L;
    private static final long DEFAULT_QUEUE_ID = 0L;
    private static final List<OFQueueDescProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long portNo;
    private final long queueId;
    private final List<OFQueueDescProp> properties;
    static final OFQueueDescVer14 DEFAULT = new OFQueueDescVer14(0L, 0L, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFQueueDescVer14Funnel FUNNEL = new OFQueueDescVer14Funnel();
    static final Writer WRITER = new Writer();

    OFQueueDescVer14(long portNo, long queueId, List<OFQueueDescProp> properties) {
        if (properties == null) {
            throw new NullPointerException("OFQueueDescVer14: property properties cannot be null");
        }
        this.portNo = portNo;
        this.queueId = queueId;
        this.properties = properties;
    }

    @Override
    public long getPortNo() {
        return this.portNo;
    }

    @Override
    public long getQueueId() {
        return this.queueId;
    }

    @Override
    public List<OFQueueDescProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFQueueDesc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueDescVer14(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("queueId=").append(this.queueId);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueDescVer14 other = (OFQueueDescVer14)obj;
        if (this.portNo != other.portNo) {
            return false;
        }
        if (this.queueId != other.queueId) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.portNo ^ this.portNo >>> 32);
        result = 31 * (int)(this.queueId ^ this.queueId >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueDescVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFQueueDescVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeInt(U32.t(message.portNo));
            bb.writeInt(U32.t(message.queueId));
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(6);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFQueueDescVer14Funnel
    implements Funnel<OFQueueDescVer14> {
        private static final long serialVersionUID = 1L;

        OFQueueDescVer14Funnel() {
        }

        public void funnel(OFQueueDescVer14 message, PrimitiveSink sink) {
            sink.putLong(message.portNo);
            sink.putLong(message.queueId);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueDesc> {
        Reader() {
        }

        @Override
        public OFQueueDesc readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            long portNo = U32.f(bb.readInt());
            long queueId = U32.f(bb.readInt());
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(6);
            List<OFQueueDescProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFQueueDescPropVer14.READER);
            OFQueueDescVer14 queueDescVer14 = new OFQueueDescVer14(portNo, queueId, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueDescVer14);
            }
            return queueDescVer14;
        }
    }

    static class Builder
    implements OFQueueDesc.Builder {
        private boolean portNoSet;
        private long portNo;
        private boolean queueIdSet;
        private long queueId;
        private boolean propertiesSet;
        private List<OFQueueDescProp> properties;

        Builder() {
        }

        @Override
        public long getPortNo() {
            return this.portNo;
        }

        @Override
        public OFQueueDesc.Builder setPortNo(long portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFQueueDesc.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public List<OFQueueDescProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFQueueDesc.Builder setProperties(List<OFQueueDescProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFQueueDesc build() {
            List<OFQueueDescProp> properties;
            long portNo = this.portNoSet ? this.portNo : 0L;
            long queueId = this.queueIdSet ? this.queueId : 0L;
            List<OFQueueDescProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFQueueDescVer14(portNo, queueId, properties);
        }
    }

    static class BuilderWithParent
    implements OFQueueDesc.Builder {
        final OFQueueDescVer14 parentMessage;
        private boolean portNoSet;
        private long portNo;
        private boolean queueIdSet;
        private long queueId;
        private boolean propertiesSet;
        private List<OFQueueDescProp> properties;

        BuilderWithParent(OFQueueDescVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getPortNo() {
            return this.portNo;
        }

        @Override
        public OFQueueDesc.Builder setPortNo(long portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFQueueDesc.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public List<OFQueueDescProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFQueueDesc.Builder setProperties(List<OFQueueDescProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFQueueDesc build() {
            List properties;
            long portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            long queueId = this.queueIdSet ? this.queueId : this.parentMessage.queueId;
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFQueueDescVer14(portNo, queueId, properties);
        }
    }
}

