/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsRequest;
import org.projectfloodlight.openflow.protocol.ver14.OFAggregateStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFDescStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFExperimenterStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFlowStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupDescStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupFeaturesStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterConfigStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterFeaturesStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPortDescStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPortStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFQueueDescStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFQueueStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFTableDescStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFTableFeaturesStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFTableStatsRequestVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsRequestVer14 {
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFStatsRequestVer14() {
    }

    static class Reader
    implements OFMessageReader<OFStatsRequest<?>> {
        Reader() {
        }

        @Override
        public OFStatsRequest<?> readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsRequestVer14.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsRequestVer14.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsRequestVer14.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsRequestVer14.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsRequestVer14.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsRequestVer14.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsRequestVer14.READER.readFrom(bb);
                }
                case 7: {
                    return OFGroupDescStatsRequestVer14.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupStatsRequestVer14.READER.readFrom(bb);
                }
                case 8: {
                    return OFGroupFeaturesStatsRequestVer14.READER.readFrom(bb);
                }
                case 10: {
                    return OFMeterConfigStatsRequestVer14.READER.readFrom(bb);
                }
                case 11: {
                    return OFMeterFeaturesStatsRequestVer14.READER.readFrom(bb);
                }
                case 9: {
                    return OFMeterStatsRequestVer14.READER.readFrom(bb);
                }
                case 13: {
                    return OFPortDescStatsRequestVer14.READER.readFrom(bb);
                }
                case 12: {
                    return OFTableFeaturesStatsRequestVer14.READER.readFrom(bb);
                }
                case 15: {
                    return OFQueueDescStatsRequestVer14.READER.readFrom(bb);
                }
                case 14: {
                    return OFTableDescStatsRequestVer14.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsRequestVer14: " + statsType);
        }
    }
}

