/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableConfig;
import org.projectfloodlight.openflow.protocol.OFTableDesc;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFTableConfigSerializerVer14;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableDescVer14
implements OFTableDesc {
    private static final Logger logger = LoggerFactory.getLogger(OFTableDescVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final Set<OFTableConfig> DEFAULT_CONFIG = ImmutableSet.of();
    private final TableId tableId;
    private final Set<OFTableConfig> config;
    static final OFTableDescVer14 DEFAULT = new OFTableDescVer14(DEFAULT_TABLE_ID, DEFAULT_CONFIG);
    static final Reader READER = new Reader();
    static final OFTableDescVer14Funnel FUNNEL = new OFTableDescVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableDescVer14(TableId tableId, Set<OFTableConfig> config) {
        if (tableId == null) {
            throw new NullPointerException("OFTableDescVer14: property tableId cannot be null");
        }
        if (config == null) {
            throw new NullPointerException("OFTableDescVer14: property config cannot be null");
        }
        this.tableId = tableId;
        this.config = config;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public Set<OFTableConfig> getConfig() {
        return this.config;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableDesc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableDescVer14(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableDescVer14 other = (OFTableDescVer14)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return !(this.config == null ? other.config != null : !this.config.equals(other.config));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableDescVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableDescVer14 message) {
            bb.writeShort(8);
            message.tableId.writeByte(bb);
            bb.writeZero(1);
            OFTableConfigSerializerVer14.writeTo(bb, message.config);
        }
    }

    static class OFTableDescVer14Funnel
    implements Funnel<OFTableDescVer14> {
        private static final long serialVersionUID = 1L;

        OFTableDescVer14Funnel() {
        }

        public void funnel(OFTableDescVer14 message, PrimitiveSink sink) {
            sink.putShort((short)8);
            message.tableId.putTo(sink);
            OFTableConfigSerializerVer14.putTo(message.config, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableDesc> {
        Reader() {
        }

        @Override
        public OFTableDesc readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(1);
            Set<OFTableConfig> config = OFTableConfigSerializerVer14.readFrom(bb);
            OFTableDescVer14 tableDescVer14 = new OFTableDescVer14(tableId, config);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableDescVer14);
            }
            return tableDescVer14;
        }
    }

    static class Builder
    implements OFTableDesc.Builder {
        private boolean tableIdSet;
        private TableId tableId;
        private boolean configSet;
        private Set<OFTableConfig> config;

        Builder() {
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableDesc.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public Set<OFTableConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFTableDesc.Builder setConfig(Set<OFTableConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableDesc build() {
            Set<OFTableConfig> config;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            Set<OFTableConfig> set = config = this.configSet ? this.config : DEFAULT_CONFIG;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            return new OFTableDescVer14(tableId, config);
        }
    }

    static class BuilderWithParent
    implements OFTableDesc.Builder {
        final OFTableDescVer14 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean configSet;
        private Set<OFTableConfig> config;

        BuilderWithParent(OFTableDescVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableDesc.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public Set<OFTableConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFTableDesc.Builder setConfig(Set<OFTableConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableDesc build() {
            Set config;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            Set set = config = this.configSet ? this.config : this.parentMessage.config;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            return new OFTableDescVer14(tableId, config);
        }
    }
}

