/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropTableSyncFrom;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropTableSyncFromVer14
implements OFTableFeaturePropTableSyncFrom {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropTableSyncFromVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    private static final List<U8> DEFAULT_TABLE_IDS = ImmutableList.of();
    private final List<U8> tableIds;
    static final OFTableFeaturePropTableSyncFromVer14 DEFAULT = new OFTableFeaturePropTableSyncFromVer14(DEFAULT_TABLE_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropTableSyncFromVer14Funnel FUNNEL = new OFTableFeaturePropTableSyncFromVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropTableSyncFromVer14(List<U8> tableIds) {
        if (tableIds == null) {
            throw new NullPointerException("OFTableFeaturePropTableSyncFromVer14: property tableIds cannot be null");
        }
        this.tableIds = tableIds;
    }

    @Override
    public int getType() {
        return 16;
    }

    @Override
    public List<U8> getTableIds() {
        return this.tableIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableFeaturePropTableSyncFrom.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropTableSyncFromVer14(");
        b.append("tableIds=").append(this.tableIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropTableSyncFromVer14 other = (OFTableFeaturePropTableSyncFromVer14)obj;
        return !(this.tableIds == null ? other.tableIds != null : !this.tableIds.equals(other.tableIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableIds == null ? 0 : this.tableIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropTableSyncFromVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableFeaturePropTableSyncFromVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(16);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.tableIds);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturePropTableSyncFromVer14Funnel
    implements Funnel<OFTableFeaturePropTableSyncFromVer14> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropTableSyncFromVer14Funnel() {
        }

        public void funnel(OFTableFeaturePropTableSyncFromVer14 message, PrimitiveSink sink) {
            sink.putShort((short)16);
            FunnelUtils.putList(message.tableIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropTableSyncFrom> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropTableSyncFrom readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 16) {
                throw new OFParseError("Wrong type: Expected=0x10(0x10), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<U8> tableIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U8.READER);
            OFTableFeaturePropTableSyncFromVer14 tableFeaturePropTableSyncFromVer14 = new OFTableFeaturePropTableSyncFromVer14(tableIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropTableSyncFromVer14);
            }
            return tableFeaturePropTableSyncFromVer14;
        }
    }

    static class Builder
    implements OFTableFeaturePropTableSyncFrom.Builder {
        private boolean tableIdsSet;
        private List<U8> tableIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 16;
        }

        @Override
        public List<U8> getTableIds() {
            return this.tableIds;
        }

        @Override
        public OFTableFeaturePropTableSyncFrom.Builder setTableIds(List<U8> tableIds) {
            this.tableIds = tableIds;
            this.tableIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropTableSyncFrom build() {
            List<U8> tableIds;
            List<U8> list = tableIds = this.tableIdsSet ? this.tableIds : DEFAULT_TABLE_IDS;
            if (tableIds == null) {
                throw new NullPointerException("Property tableIds must not be null");
            }
            return new OFTableFeaturePropTableSyncFromVer14(tableIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropTableSyncFrom.Builder {
        final OFTableFeaturePropTableSyncFromVer14 parentMessage;
        private boolean tableIdsSet;
        private List<U8> tableIds;

        BuilderWithParent(OFTableFeaturePropTableSyncFromVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 16;
        }

        @Override
        public List<U8> getTableIds() {
            return this.tableIds;
        }

        @Override
        public OFTableFeaturePropTableSyncFrom.Builder setTableIds(List<U8> tableIds) {
            this.tableIds = tableIds;
            this.tableIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropTableSyncFrom build() {
            List tableIds;
            List list = tableIds = this.tableIdsSet ? this.tableIds : this.parentMessage.tableIds;
            if (tableIds == null) {
                throw new NullPointerException("Property tableIds must not be null");
            }
            return new OFTableFeaturePropTableSyncFromVer14(tableIds);
        }
    }
}

