/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableModPropEviction;
import org.projectfloodlight.openflow.protocol.OFTableModPropEvictionFlag;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFTableModPropEvictionFlagSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableModPropEvictionVer14
implements OFTableModPropEviction {
    private static final Logger logger = LoggerFactory.getLogger(OFTableModPropEvictionVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final Set<OFTableModPropEvictionFlag> DEFAULT_FLAGS = ImmutableSet.of();
    private final Set<OFTableModPropEvictionFlag> flags;
    static final OFTableModPropEvictionVer14 DEFAULT = new OFTableModPropEvictionVer14(DEFAULT_FLAGS);
    static final Reader READER = new Reader();
    static final OFTableModPropEvictionVer14Funnel FUNNEL = new OFTableModPropEvictionVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableModPropEvictionVer14(Set<OFTableModPropEvictionFlag> flags) {
        if (flags == null) {
            throw new NullPointerException("OFTableModPropEvictionVer14: property flags cannot be null");
        }
        this.flags = flags;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public Set<OFTableModPropEvictionFlag> getFlags() {
        return this.flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableModPropEviction.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableModPropEvictionVer14(");
        b.append("flags=").append(this.flags);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableModPropEvictionVer14 other = (OFTableModPropEvictionVer14)obj;
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableModPropEvictionVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableModPropEvictionVer14 message) {
            bb.writeShort(2);
            bb.writeShort(8);
            OFTableModPropEvictionFlagSerializerVer14.writeTo(bb, message.flags);
        }
    }

    static class OFTableModPropEvictionVer14Funnel
    implements Funnel<OFTableModPropEvictionVer14> {
        private static final long serialVersionUID = 1L;

        OFTableModPropEvictionVer14Funnel() {
        }

        public void funnel(OFTableModPropEvictionVer14 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            sink.putShort((short)8);
            OFTableModPropEvictionFlagSerializerVer14.putTo(message.flags, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableModPropEviction> {
        Reader() {
        }

        @Override
        public OFTableModPropEviction readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=0x2(0x2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFTableModPropEvictionFlag> flags = OFTableModPropEvictionFlagSerializerVer14.readFrom(bb);
            OFTableModPropEvictionVer14 tableModPropEvictionVer14 = new OFTableModPropEvictionVer14(flags);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableModPropEvictionVer14);
            }
            return tableModPropEvictionVer14;
        }
    }

    static class Builder
    implements OFTableModPropEviction.Builder {
        private boolean flagsSet;
        private Set<OFTableModPropEvictionFlag> flags;

        Builder() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public Set<OFTableModPropEvictionFlag> getFlags() {
            return this.flags;
        }

        @Override
        public OFTableModPropEviction.Builder setFlags(Set<OFTableModPropEvictionFlag> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableModPropEviction build() {
            Set<OFTableModPropEvictionFlag> flags;
            Set<OFTableModPropEvictionFlag> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFTableModPropEvictionVer14(flags);
        }
    }

    static class BuilderWithParent
    implements OFTableModPropEviction.Builder {
        final OFTableModPropEvictionVer14 parentMessage;
        private boolean flagsSet;
        private Set<OFTableModPropEvictionFlag> flags;

        BuilderWithParent(OFTableModPropEvictionVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public Set<OFTableModPropEvictionFlag> getFlags() {
            return this.flags;
        }

        @Override
        public OFTableModPropEviction.Builder setFlags(Set<OFTableModPropEvictionFlag> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableModPropEviction build() {
            Set flags;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFTableModPropEvictionVer14(flags);
        }
    }
}

