/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.base.Preconditions;
import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.DatapathId;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.util.HexString;

public class MacAddress
implements OFValueType<MacAddress> {
    static final int MacAddrLen = 6;
    private final long rawValue;
    private static final long NONE_VAL = 0L;
    public static final MacAddress NONE = new MacAddress(0L);
    private static final long BROADCAST_VAL = 0xFFFFFFFFFFFFL;
    public static final MacAddress BROADCAST = new MacAddress(0xFFFFFFFFFFFFL);
    public static final MacAddress NO_MASK = MacAddress.of(-1L);
    public static final MacAddress FULL_MASK = MacAddress.of(0L);
    private static final long LLDP_MAC_ADDRESS_MASK = 0xFFFFFFFFFFF0L;
    private static final long LLDP_MAC_ADDRESS_VALUE = 1652522221568L;
    private static final String FORMAT_ERROR = "Mac address is not well-formed. It must consist of 6 hex digit pairs separated by colons: ";
    private static final int MAC_STRING_LENGTH = 17;
    private volatile byte[] bytesCache = null;

    private MacAddress(long rawValue) {
        this.rawValue = rawValue;
    }

    public static MacAddress of(byte[] address) {
        if (address.length != 6) {
            throw new IllegalArgumentException("Mac address byte array must be exactly 6 bytes long; length = " + address.length);
        }
        long raw = ((long)address[0] & 0xFFL) << 40 | ((long)address[1] & 0xFFL) << 32 | ((long)address[2] & 0xFFL) << 24 | ((long)address[3] & 0xFFL) << 16 | ((long)address[4] & 0xFFL) << 8 | (long)address[5] & 0xFFL;
        return MacAddress.of(raw);
    }

    public static MacAddress of(long raw) {
        if ((raw &= 0xFFFFFFFFFFFFL) == 0L) {
            return NONE;
        }
        if (raw == 0xFFFFFFFFFFFFL) {
            return BROADCAST;
        }
        return new MacAddress(raw);
    }

    @Nonnull
    public static MacAddress of(@Nonnull String macString) throws IllegalArgumentException {
        if (macString == null) {
            throw new NullPointerException("macString must not be null");
        }
        int index = 0;
        long raw = 0L;
        if (macString.length() != 17) {
            throw new IllegalArgumentException(FORMAT_ERROR + macString);
        }
        for (int shift = 40; shift >= 0; shift -= 8) {
            int digit1 = Character.digit(macString.charAt(index++), 16);
            int digit2 = Character.digit(macString.charAt(index++), 16);
            if (digit1 < 0 || digit2 < 0) {
                throw new IllegalArgumentException(FORMAT_ERROR + macString);
            }
            raw |= (long)(digit1 << 4 | digit2) << shift;
            if (shift == 0) break;
            if (macString.charAt(index++) == ':') continue;
            throw new IllegalArgumentException(FORMAT_ERROR + macString);
        }
        return MacAddress.of(raw);
    }

    public static MacAddress of(@Nonnull DatapathId dpid) {
        Preconditions.checkNotNull((Object)dpid, (Object)"dpid must not be null");
        long raw = dpid.getLong();
        if ((raw & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("First two bytes of supplied Datapathid must be 0");
        }
        return MacAddress.of(raw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        if (this.bytesCache == null) {
            MacAddress macAddress = this;
            synchronized (macAddress) {
                if (this.bytesCache == null) {
                    this.bytesCache = new byte[]{(byte)(this.rawValue >> 40 & 0xFFL), (byte)(this.rawValue >> 32 & 0xFFL), (byte)(this.rawValue >> 24 & 0xFFL), (byte)(this.rawValue >> 16 & 0xFFL), (byte)(this.rawValue >> 8 & 0xFFL), (byte)(this.rawValue >> 0 & 0xFFL)};
                }
            }
        }
        return Arrays.copyOf(this.bytesCache, this.bytesCache.length);
    }

    public boolean isBroadcast() {
        return this == BROADCAST;
    }

    public boolean isMulticast() {
        if (this.isBroadcast()) {
            return false;
        }
        return (this.rawValue & 0x10000000000L) != 0L;
    }

    public boolean isLLDPAddress() {
        return (this.rawValue & 0xFFFFFFFFFFF0L) == 1652522221568L;
    }

    @Override
    public int getLength() {
        return 6;
    }

    public String toString() {
        return HexString.toHexString(this.rawValue, 6);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.rawValue ^ this.rawValue >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MacAddress other = (MacAddress)obj;
        return this.rawValue == other.rawValue;
    }

    public long getLong() {
        return this.rawValue;
    }

    public void write6Bytes(ChannelBuffer c) {
        c.writeInt((int)(this.rawValue >> 16));
        c.writeShort((int)this.rawValue & 0xFFFF);
    }

    public static MacAddress read6Bytes(ChannelBuffer c) throws OFParseError {
        long raw = c.readUnsignedInt() << 16 | (long)c.readUnsignedShort();
        return MacAddress.of(raw);
    }

    @Override
    public MacAddress applyMask(MacAddress mask) {
        return MacAddress.of(this.rawValue & mask.rawValue);
    }

    @Override
    public int compareTo(MacAddress o) {
        return Longs.compare((long)this.rawValue, (long)o.rawValue);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt((int)(this.rawValue >> 16));
        sink.putShort((short)(this.rawValue & 0xFFFFL));
    }
}

