/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import javax.annotation.concurrent.Immutable;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.types.OFValueType;

@Immutable
public class VRF
implements OFValueType<VRF> {
    static final int LENGTH = 4;
    private final int rawValue;
    public static final VRF ZERO = VRF.of(0);
    public static final VRF NO_MASK = VRF.of(-1);
    public static final VRF FULL_MASK = VRF.of(0);

    private VRF(int rawValue) {
        this.rawValue = rawValue;
    }

    public static VRF of(int raw) {
        return new VRF(raw);
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public int getLength() {
        return 4;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rawValue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VRF other = (VRF)obj;
        return this.rawValue == other.rawValue;
    }

    public String toString() {
        return Integer.toString(this.rawValue);
    }

    public void write4Bytes(ChannelBuffer c) {
        c.writeInt(this.rawValue);
    }

    public static VRF read4Bytes(ChannelBuffer c) {
        return VRF.of(c.readInt());
    }

    @Override
    public VRF applyMask(VRF mask) {
        return VRF.of(this.rawValue & mask.rawValue);
    }

    @Override
    public int compareTo(VRF o) {
        return UnsignedInts.compare((int)this.rawValue, (int)o.rawValue);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.rawValue);
    }
}

