// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFActionNiciraSetNshc3Ver13 implements OFActionNiciraSetNshc3 {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraSetNshc3Ver13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 16;

        private final static long DEFAULT_NSHC3 = 0x0L;

    // OF message fields
    private final long nshc3;
//
    // Immutable default instance
    final static OFActionNiciraSetNshc3Ver13 DEFAULT = new OFActionNiciraSetNshc3Ver13(
        DEFAULT_NSHC3
    );

    // package private constructor - used by readers, builders, and factory
    OFActionNiciraSetNshc3Ver13(long nshc3) {
        this.nshc3 = nshc3;
    }

    // Accessors for OF message fields
    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x24;
    }

    @Override
    public long getNshc3() {
        return nshc3;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFActionNiciraSetNshc3.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFActionNiciraSetNshc3.Builder {
        final OFActionNiciraSetNshc3Ver13 parentMessage;

        // OF message fields
        private boolean nshc3Set;
        private long nshc3;

        BuilderWithParent(OFActionNiciraSetNshc3Ver13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x24;
    }

    @Override
    public long getNshc3() {
        return nshc3;
    }

    @Override
    public OFActionNiciraSetNshc3.Builder setNshc3(long nshc3) {
        this.nshc3 = nshc3;
        this.nshc3Set = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFActionNiciraSetNshc3 build() {
                long nshc3 = this.nshc3Set ? this.nshc3 : parentMessage.nshc3;

                //
                return new OFActionNiciraSetNshc3Ver13(
                    nshc3
                );
        }

    }

    static class Builder implements OFActionNiciraSetNshc3.Builder {
        // OF message fields
        private boolean nshc3Set;
        private long nshc3;

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x24;
    }

    @Override
    public long getNshc3() {
        return nshc3;
    }

    @Override
    public OFActionNiciraSetNshc3.Builder setNshc3(long nshc3) {
        this.nshc3 = nshc3;
        this.nshc3Set = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFActionNiciraSetNshc3 build() {
            long nshc3 = this.nshc3Set ? this.nshc3 : DEFAULT_NSHC3;


            return new OFActionNiciraSetNshc3Ver13(
                    nshc3
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFActionNiciraSetNshc3> {
        @Override
        public OFActionNiciraSetNshc3 readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 65535
            short type = bb.readShort();
            if(type != (short) 0xffff)
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 16)
                throw new OFParseError("Wrong length: Expected=16(16), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // fixed value property experimenter == 0x2320L
            int experimenter = bb.readInt();
            if(experimenter != 0x2320)
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got="+experimenter);
            // fixed value property subtype == 0x24
            short subtype = bb.readShort();
            if(subtype != (short) 0x24)
                throw new OFParseError("Wrong subtype: Expected=0x24(0x24), got="+subtype);
            // pad: 2 bytes
            bb.skipBytes(2);
            long nshc3 = U32.f(bb.readInt());

            OFActionNiciraSetNshc3Ver13 actionNiciraSetNshc3Ver13 = new OFActionNiciraSetNshc3Ver13(
                    nshc3
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", actionNiciraSetNshc3Ver13);
            return actionNiciraSetNshc3Ver13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFActionNiciraSetNshc3Ver13Funnel FUNNEL = new OFActionNiciraSetNshc3Ver13Funnel();
    static class OFActionNiciraSetNshc3Ver13Funnel implements Funnel<OFActionNiciraSetNshc3Ver13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFActionNiciraSetNshc3Ver13 message, PrimitiveSink sink) {
            // fixed value property type = 65535
            sink.putShort((short) 0xffff);
            // fixed value property length = 16
            sink.putShort((short) 0x10);
            // fixed value property experimenter = 0x2320L
            sink.putInt(0x2320);
            // fixed value property subtype = 0x24
            sink.putShort((short) 0x24);
            // skip pad (2 bytes)
            sink.putLong(message.nshc3);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFActionNiciraSetNshc3Ver13> {
        @Override
        public void write(ChannelBuffer bb, OFActionNiciraSetNshc3Ver13 message) {
            // fixed value property type = 65535
            bb.writeShort((short) 0xffff);
            // fixed value property length = 16
            bb.writeShort((short) 0x10);
            // fixed value property experimenter = 0x2320L
            bb.writeInt(0x2320);
            // fixed value property subtype = 0x24
            bb.writeShort((short) 0x24);
            // pad: 2 bytes
            bb.writeZero(2);
            bb.writeInt(U32.t(message.nshc3));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraSetNshc3Ver13(");
        b.append("nshc3=").append(nshc3);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFActionNiciraSetNshc3Ver13 other = (OFActionNiciraSetNshc3Ver13) obj;

        if( nshc3 != other.nshc3)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (nshc3 ^ (nshc3 >>> 32));
        return result;
    }

}
