// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFActionNiciraSetNshc4Ver13 implements OFActionNiciraSetNshc4 {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraSetNshc4Ver13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 16;

        private final static long DEFAULT_NSHC4 = 0x0L;

    // OF message fields
    private final long nshc4;
//
    // Immutable default instance
    final static OFActionNiciraSetNshc4Ver13 DEFAULT = new OFActionNiciraSetNshc4Ver13(
        DEFAULT_NSHC4
    );

    // package private constructor - used by readers, builders, and factory
    OFActionNiciraSetNshc4Ver13(long nshc4) {
        this.nshc4 = nshc4;
    }

    // Accessors for OF message fields
    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x25;
    }

    @Override
    public long getNshc4() {
        return nshc4;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFActionNiciraSetNshc4.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFActionNiciraSetNshc4.Builder {
        final OFActionNiciraSetNshc4Ver13 parentMessage;

        // OF message fields
        private boolean nshc4Set;
        private long nshc4;

        BuilderWithParent(OFActionNiciraSetNshc4Ver13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x25;
    }

    @Override
    public long getNshc4() {
        return nshc4;
    }

    @Override
    public OFActionNiciraSetNshc4.Builder setNshc4(long nshc4) {
        this.nshc4 = nshc4;
        this.nshc4Set = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFActionNiciraSetNshc4 build() {
                long nshc4 = this.nshc4Set ? this.nshc4 : parentMessage.nshc4;

                //
                return new OFActionNiciraSetNshc4Ver13(
                    nshc4
                );
        }

    }

    static class Builder implements OFActionNiciraSetNshc4.Builder {
        // OF message fields
        private boolean nshc4Set;
        private long nshc4;

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x25;
    }

    @Override
    public long getNshc4() {
        return nshc4;
    }

    @Override
    public OFActionNiciraSetNshc4.Builder setNshc4(long nshc4) {
        this.nshc4 = nshc4;
        this.nshc4Set = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFActionNiciraSetNshc4 build() {
            long nshc4 = this.nshc4Set ? this.nshc4 : DEFAULT_NSHC4;


            return new OFActionNiciraSetNshc4Ver13(
                    nshc4
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFActionNiciraSetNshc4> {
        @Override
        public OFActionNiciraSetNshc4 readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 65535
            short type = bb.readShort();
            if(type != (short) 0xffff)
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 16)
                throw new OFParseError("Wrong length: Expected=16(16), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // fixed value property experimenter == 0x2320L
            int experimenter = bb.readInt();
            if(experimenter != 0x2320)
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got="+experimenter);
            // fixed value property subtype == 0x25
            short subtype = bb.readShort();
            if(subtype != (short) 0x25)
                throw new OFParseError("Wrong subtype: Expected=0x25(0x25), got="+subtype);
            // pad: 2 bytes
            bb.skipBytes(2);
            long nshc4 = U32.f(bb.readInt());

            OFActionNiciraSetNshc4Ver13 actionNiciraSetNshc4Ver13 = new OFActionNiciraSetNshc4Ver13(
                    nshc4
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", actionNiciraSetNshc4Ver13);
            return actionNiciraSetNshc4Ver13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFActionNiciraSetNshc4Ver13Funnel FUNNEL = new OFActionNiciraSetNshc4Ver13Funnel();
    static class OFActionNiciraSetNshc4Ver13Funnel implements Funnel<OFActionNiciraSetNshc4Ver13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFActionNiciraSetNshc4Ver13 message, PrimitiveSink sink) {
            // fixed value property type = 65535
            sink.putShort((short) 0xffff);
            // fixed value property length = 16
            sink.putShort((short) 0x10);
            // fixed value property experimenter = 0x2320L
            sink.putInt(0x2320);
            // fixed value property subtype = 0x25
            sink.putShort((short) 0x25);
            // skip pad (2 bytes)
            sink.putLong(message.nshc4);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFActionNiciraSetNshc4Ver13> {
        @Override
        public void write(ChannelBuffer bb, OFActionNiciraSetNshc4Ver13 message) {
            // fixed value property type = 65535
            bb.writeShort((short) 0xffff);
            // fixed value property length = 16
            bb.writeShort((short) 0x10);
            // fixed value property experimenter = 0x2320L
            bb.writeInt(0x2320);
            // fixed value property subtype = 0x25
            bb.writeShort((short) 0x25);
            // pad: 2 bytes
            bb.writeZero(2);
            bb.writeInt(U32.t(message.nshc4));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraSetNshc4Ver13(");
        b.append("nshc4=").append(nshc4);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFActionNiciraSetNshc4Ver13 other = (OFActionNiciraSetNshc4Ver13) obj;

        if( nshc4 != other.nshc4)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (nshc4 ^ (nshc4 >>> 32));
        return result;
    }

}
