/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.match;

import java.util.HashSet;
import java.util.Set;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.types.OFValueType;

public class Prerequisite<T extends OFValueType<T>> {
    private final MatchField<T> field;
    private final Set<OFValueType<T>> values = new HashSet<OFValueType<T>>();
    private boolean any;

    @SafeVarargs
    public Prerequisite(MatchField<T> field, OFValueType<T> ... values) {
        this.field = field;
        if (values == null || values.length == 0) {
            this.any = true;
        } else {
            this.any = false;
            for (OFValueType<T> value : values) {
                this.values.add(value);
            }
        }
    }

    public boolean isSatisfied(Match match) {
        T res = match.get(this.field);
        if (res == null) {
            return false;
        }
        if (this.any) {
            return true;
        }
        return this.values.contains(res);
    }
}

