/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.action.OFActionBsn;
import org.projectfloodlight.openflow.protocol.ver10.OFActionBsnChecksumVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFActionBsnMirrorVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFActionBsnSetTunnelDstVer10;
import org.projectfloodlight.openflow.types.U16;

abstract class OFActionBsnVer10 {
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFActionBsnVer10() {
    }

    static class Reader
    implements OFMessageReader<OFActionBsn> {
        Reader() {
        }

        @Override
        public OFActionBsn readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 4: {
                    return OFActionBsnChecksumVer10.READER.readFrom(bb);
                }
                case 1: {
                    return OFActionBsnMirrorVer10.READER.readFrom(bb);
                }
                case 2: {
                    return OFActionBsnSetTunnelDstVer10.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFActionBsnVer10: " + subtype);
        }
    }
}

