/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBucket;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.ver11.OFActionVer11;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBucketVer11
implements OFBucket {
    private static final Logger logger = LoggerFactory.getLogger(OFBucketVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 16;
    private static final int DEFAULT_WEIGHT = 0;
    private static final OFPort DEFAULT_WATCH_PORT = OFPort.ANY;
    private static final OFGroup DEFAULT_WATCH_GROUP = OFGroup.ALL;
    private static final List<OFAction> DEFAULT_ACTIONS = ImmutableList.of();
    private final int weight;
    private final OFPort watchPort;
    private final OFGroup watchGroup;
    private final List<OFAction> actions;
    static final OFBucketVer11 DEFAULT = new OFBucketVer11(0, DEFAULT_WATCH_PORT, DEFAULT_WATCH_GROUP, DEFAULT_ACTIONS);
    static final Reader READER = new Reader();
    static final OFBucketVer11Funnel FUNNEL = new OFBucketVer11Funnel();
    static final Writer WRITER = new Writer();

    OFBucketVer11(int weight, OFPort watchPort, OFGroup watchGroup, List<OFAction> actions) {
        if (watchPort == null) {
            throw new NullPointerException("OFBucketVer11: property watchPort cannot be null");
        }
        if (watchGroup == null) {
            throw new NullPointerException("OFBucketVer11: property watchGroup cannot be null");
        }
        if (actions == null) {
            throw new NullPointerException("OFBucketVer11: property actions cannot be null");
        }
        this.weight = weight;
        this.watchPort = watchPort;
        this.watchGroup = watchGroup;
        this.actions = actions;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public OFPort getWatchPort() {
        return this.watchPort;
    }

    @Override
    public OFGroup getWatchGroup() {
        return this.watchGroup;
    }

    @Override
    public List<OFAction> getActions() {
        return this.actions;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFBucket.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBucketVer11(");
        b.append("weight=").append(this.weight);
        b.append(", ");
        b.append("watchPort=").append(this.watchPort);
        b.append(", ");
        b.append("watchGroup=").append(this.watchGroup);
        b.append(", ");
        b.append("actions=").append(this.actions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBucketVer11 other = (OFBucketVer11)obj;
        if (this.weight != other.weight) {
            return false;
        }
        if (this.watchPort == null ? other.watchPort != null : !this.watchPort.equals(other.watchPort)) {
            return false;
        }
        if (this.watchGroup == null ? other.watchGroup != null : !this.watchGroup.equals(other.watchGroup)) {
            return false;
        }
        return !(this.actions == null ? other.actions != null : !this.actions.equals(other.actions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.weight;
        result = 31 * result + (this.watchPort == null ? 0 : this.watchPort.hashCode());
        result = 31 * result + (this.watchGroup == null ? 0 : this.watchGroup.hashCode());
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBucketVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBucketVer11 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeShort((int)U16.t(message.weight));
            message.watchPort.write4Bytes(bb);
            message.watchGroup.write4Bytes(bb);
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.actions);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBucketVer11Funnel
    implements Funnel<OFBucketVer11> {
        private static final long serialVersionUID = 1L;

        OFBucketVer11Funnel() {
        }

        public void funnel(OFBucketVer11 message, PrimitiveSink sink) {
            sink.putInt(message.weight);
            message.watchPort.putTo(sink);
            message.watchGroup.putTo(sink);
            FunnelUtils.putList(message.actions, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBucket> {
        Reader() {
        }

        @Override
        public OFBucket readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int weight = U16.f(bb.readShort());
            OFPort watchPort = OFPort.read4Bytes(bb);
            OFGroup watchGroup = OFGroup.read4Bytes(bb);
            bb.skipBytes(4);
            List<OFAction> actions = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFActionVer11.READER);
            OFBucketVer11 bucketVer11 = new OFBucketVer11(weight, watchPort, watchGroup, actions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bucketVer11);
            }
            return bucketVer11;
        }
    }

    static class Builder
    implements OFBucket.Builder {
        private boolean weightSet;
        private int weight;
        private boolean watchPortSet;
        private OFPort watchPort;
        private boolean watchGroupSet;
        private OFGroup watchGroup;
        private boolean actionsSet;
        private List<OFAction> actions;

        Builder() {
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public OFBucket.Builder setWeight(int weight) {
            this.weight = weight;
            this.weightSet = true;
            return this;
        }

        @Override
        public OFPort getWatchPort() {
            return this.watchPort;
        }

        @Override
        public OFBucket.Builder setWatchPort(OFPort watchPort) {
            this.watchPort = watchPort;
            this.watchPortSet = true;
            return this;
        }

        @Override
        public OFGroup getWatchGroup() {
            return this.watchGroup;
        }

        @Override
        public OFBucket.Builder setWatchGroup(OFGroup watchGroup) {
            this.watchGroup = watchGroup;
            this.watchGroupSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFBucket.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFBucket build() {
            List<OFAction> actions;
            OFGroup watchGroup;
            OFPort watchPort;
            int weight = this.weightSet ? this.weight : 0;
            OFPort oFPort = watchPort = this.watchPortSet ? this.watchPort : DEFAULT_WATCH_PORT;
            if (watchPort == null) {
                throw new NullPointerException("Property watchPort must not be null");
            }
            OFGroup oFGroup = watchGroup = this.watchGroupSet ? this.watchGroup : DEFAULT_WATCH_GROUP;
            if (watchGroup == null) {
                throw new NullPointerException("Property watchGroup must not be null");
            }
            List<OFAction> list = actions = this.actionsSet ? this.actions : DEFAULT_ACTIONS;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            return new OFBucketVer11(weight, watchPort, watchGroup, actions);
        }
    }

    static class BuilderWithParent
    implements OFBucket.Builder {
        final OFBucketVer11 parentMessage;
        private boolean weightSet;
        private int weight;
        private boolean watchPortSet;
        private OFPort watchPort;
        private boolean watchGroupSet;
        private OFGroup watchGroup;
        private boolean actionsSet;
        private List<OFAction> actions;

        BuilderWithParent(OFBucketVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public OFBucket.Builder setWeight(int weight) {
            this.weight = weight;
            this.weightSet = true;
            return this;
        }

        @Override
        public OFPort getWatchPort() {
            return this.watchPort;
        }

        @Override
        public OFBucket.Builder setWatchPort(OFPort watchPort) {
            this.watchPort = watchPort;
            this.watchPortSet = true;
            return this;
        }

        @Override
        public OFGroup getWatchGroup() {
            return this.watchGroup;
        }

        @Override
        public OFBucket.Builder setWatchGroup(OFGroup watchGroup) {
            this.watchGroup = watchGroup;
            this.watchGroupSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFBucket.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFBucket build() {
            List actions;
            OFGroup watchGroup;
            OFPort watchPort;
            int weight = this.weightSet ? this.weight : this.parentMessage.weight;
            OFPort oFPort = watchPort = this.watchPortSet ? this.watchPort : this.parentMessage.watchPort;
            if (watchPort == null) {
                throw new NullPointerException("Property watchPort must not be null");
            }
            OFGroup oFGroup = watchGroup = this.watchGroupSet ? this.watchGroup : this.parentMessage.watchGroup;
            if (watchGroup == null) {
                throw new NullPointerException("Property watchGroup must not be null");
            }
            List list = actions = this.actionsSet ? this.actions : this.parentMessage.actions;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            return new OFBucketVer11(weight, watchPort, watchGroup, actions);
        }
    }
}

