/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver11.OFFlowAddVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFFlowDeleteStrictVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFFlowDeleteVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFFlowModifyStrictVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFFlowModifyVer11;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;

abstract class OFFlowModVer11 {
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 136;
    public static final Reader READER = new Reader();

    OFFlowModVer11() {
    }

    static class Reader
    implements OFMessageReader<OFFlowMod> {
        Reader() {
        }

        @Override
        public OFFlowMod readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 136) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 14) {
                throw new OFParseError("Wrong type: Expected=OFType.FLOW_MOD(14), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 136) {
                throw new OFParseError("Wrong length: Expected to be >= 136, was: " + length);
            }
            U32.f(bb.readInt());
            U64.ofRaw(bb.readLong());
            U64.ofRaw(bb.readLong());
            TableId.readByte(bb);
            short command = bb.readByte();
            bb.readerIndex(start);
            switch (command) {
                case 0: {
                    return OFFlowAddVer11.READER.readFrom(bb);
                }
                case 3: {
                    return OFFlowDeleteVer11.READER.readFrom(bb);
                }
                case 4: {
                    return OFFlowDeleteStrictVer11.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowModifyVer11.READER.readFrom(bb);
                }
                case 2: {
                    return OFFlowModifyStrictVer11.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator command of class OFFlowModVer11: " + command);
        }
    }
}

