/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraSetNshc4;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraSetNshc4Ver12
implements OFActionNiciraSetNshc4 {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraSetNshc4Ver12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 16;
    private static final long DEFAULT_NSHC4 = 0L;
    private final long nshc4;
    static final OFActionNiciraSetNshc4Ver12 DEFAULT = new OFActionNiciraSetNshc4Ver12(0L);
    static final Reader READER = new Reader();
    static final OFActionNiciraSetNshc4Ver12Funnel FUNNEL = new OFActionNiciraSetNshc4Ver12Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraSetNshc4Ver12(long nshc4) {
        this.nshc4 = nshc4;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 37;
    }

    @Override
    public long getNshc4() {
        return this.nshc4;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFActionNiciraSetNshc4.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraSetNshc4Ver12(");
        b.append("nshc4=").append(this.nshc4);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraSetNshc4Ver12 other = (OFActionNiciraSetNshc4Ver12)obj;
        return this.nshc4 == other.nshc4;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.nshc4 ^ this.nshc4 >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraSetNshc4Ver12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraSetNshc4Ver12 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(8992);
            bb.writeShort(37);
            bb.writeZero(2);
            bb.writeInt(U32.t(message.nshc4));
        }
    }

    static class OFActionNiciraSetNshc4Ver12Funnel
    implements Funnel<OFActionNiciraSetNshc4Ver12> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraSetNshc4Ver12Funnel() {
        }

        public void funnel(OFActionNiciraSetNshc4Ver12 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(8992);
            sink.putShort((short)37);
            sink.putLong(message.nshc4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraSetNshc4> {
        Reader() {
        }

        @Override
        public OFActionNiciraSetNshc4 readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 37) {
                throw new OFParseError("Wrong subtype: Expected=0x25(0x25), got=" + subtype);
            }
            bb.skipBytes(2);
            long nshc4 = U32.f(bb.readInt());
            OFActionNiciraSetNshc4Ver12 actionNiciraSetNshc4Ver12 = new OFActionNiciraSetNshc4Ver12(nshc4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraSetNshc4Ver12);
            }
            return actionNiciraSetNshc4Ver12;
        }
    }

    static class Builder
    implements OFActionNiciraSetNshc4.Builder {
        private boolean nshc4Set;
        private long nshc4;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 37;
        }

        @Override
        public long getNshc4() {
            return this.nshc4;
        }

        @Override
        public OFActionNiciraSetNshc4.Builder setNshc4(long nshc4) {
            this.nshc4 = nshc4;
            this.nshc4Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionNiciraSetNshc4 build() {
            long nshc4 = this.nshc4Set ? this.nshc4 : 0L;
            return new OFActionNiciraSetNshc4Ver12(nshc4);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraSetNshc4.Builder {
        final OFActionNiciraSetNshc4Ver12 parentMessage;
        private boolean nshc4Set;
        private long nshc4;

        BuilderWithParent(OFActionNiciraSetNshc4Ver12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 37;
        }

        @Override
        public long getNshc4() {
            return this.nshc4;
        }

        @Override
        public OFActionNiciraSetNshc4.Builder setNshc4(long nshc4) {
            this.nshc4 = nshc4;
            this.nshc4Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionNiciraSetNshc4 build() {
            long nshc4 = this.nshc4Set ? this.nshc4 : this.parentMessage.nshc4;
            return new OFActionNiciraSetNshc4Ver12(nshc4);
        }
    }
}

