/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnArpIdle;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnArpIdleVer13
implements OFBsnArpIdle {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnArpIdleVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final int DEFAULT_VLAN_VID = 0;
    private static final IPv4Address DEFAULT_IPV4_ADDR = IPv4Address.NONE;
    private final long xid;
    private final int vlanVid;
    private final IPv4Address ipv4Addr;
    static final OFBsnArpIdleVer13 DEFAULT = new OFBsnArpIdleVer13(0L, 0, DEFAULT_IPV4_ADDR);
    static final Reader READER = new Reader();
    static final OFBsnArpIdleVer13Funnel FUNNEL = new OFBsnArpIdleVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnArpIdleVer13(long xid, int vlanVid, IPv4Address ipv4Addr) {
        if (ipv4Addr == null) {
            throw new NullPointerException("OFBsnArpIdleVer13: property ipv4Addr cannot be null");
        }
        this.xid = xid;
        this.vlanVid = vlanVid;
        this.ipv4Addr = ipv4Addr;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 60L;
    }

    @Override
    public int getVlanVid() {
        return this.vlanVid;
    }

    @Override
    public IPv4Address getIpv4Addr() {
        return this.ipv4Addr;
    }

    @Override
    public OFBsnArpIdle.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnArpIdleVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("vlanVid=").append(this.vlanVid);
        b.append(", ");
        b.append("ipv4Addr=").append(this.ipv4Addr);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnArpIdleVer13 other = (OFBsnArpIdleVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.vlanVid != other.vlanVid) {
            return false;
        }
        return !(this.ipv4Addr == null ? other.ipv4Addr != null : !this.ipv4Addr.equals(other.ipv4Addr));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.vlanVid;
        result = 31 * result + (this.ipv4Addr == null ? 0 : this.ipv4Addr.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnArpIdleVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnArpIdleVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(60);
            bb.writeShort((int)U16.t(message.vlanVid));
            bb.writeZero(2);
            message.ipv4Addr.write4Bytes(bb);
        }
    }

    static class OFBsnArpIdleVer13Funnel
    implements Funnel<OFBsnArpIdleVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnArpIdleVer13Funnel() {
        }

        public void funnel(OFBsnArpIdleVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(60);
            sink.putInt(message.vlanVid);
            message.ipv4Addr.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnArpIdle> {
        Reader() {
        }

        @Override
        public OFBsnArpIdle readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 60) {
                throw new OFParseError("Wrong subtype: Expected=0x3cL(0x3cL), got=" + subtype);
            }
            int vlanVid = U16.f(bb.readShort());
            bb.skipBytes(2);
            IPv4Address ipv4Addr = IPv4Address.read4Bytes(bb);
            OFBsnArpIdleVer13 bsnArpIdleVer13 = new OFBsnArpIdleVer13(xid, vlanVid, ipv4Addr);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnArpIdleVer13);
            }
            return bsnArpIdleVer13;
        }
    }

    static class Builder
    implements OFBsnArpIdle.Builder {
        private boolean xidSet;
        private long xid;
        private boolean vlanVidSet;
        private int vlanVid;
        private boolean ipv4AddrSet;
        private IPv4Address ipv4Addr;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnArpIdle.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 60L;
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFBsnArpIdle.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Addr() {
            return this.ipv4Addr;
        }

        @Override
        public OFBsnArpIdle.Builder setIpv4Addr(IPv4Address ipv4Addr) {
            this.ipv4Addr = ipv4Addr;
            this.ipv4AddrSet = true;
            return this;
        }

        @Override
        public OFBsnArpIdle build() {
            IPv4Address ipv4Addr;
            long xid = this.xidSet ? this.xid : 0L;
            int vlanVid = this.vlanVidSet ? this.vlanVid : 0;
            IPv4Address iPv4Address = ipv4Addr = this.ipv4AddrSet ? this.ipv4Addr : DEFAULT_IPV4_ADDR;
            if (ipv4Addr == null) {
                throw new NullPointerException("Property ipv4Addr must not be null");
            }
            return new OFBsnArpIdleVer13(xid, vlanVid, ipv4Addr);
        }
    }

    static class BuilderWithParent
    implements OFBsnArpIdle.Builder {
        final OFBsnArpIdleVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean vlanVidSet;
        private int vlanVid;
        private boolean ipv4AddrSet;
        private IPv4Address ipv4Addr;

        BuilderWithParent(OFBsnArpIdleVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnArpIdle.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 60L;
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFBsnArpIdle.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Addr() {
            return this.ipv4Addr;
        }

        @Override
        public OFBsnArpIdle.Builder setIpv4Addr(IPv4Address ipv4Addr) {
            this.ipv4Addr = ipv4Addr;
            this.ipv4AddrSet = true;
            return this;
        }

        @Override
        public OFBsnArpIdle build() {
            IPv4Address ipv4Addr;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            int vlanVid = this.vlanVidSet ? this.vlanVid : this.parentMessage.vlanVid;
            IPv4Address iPv4Address = ipv4Addr = this.ipv4AddrSet ? this.ipv4Addr : this.parentMessage.ipv4Addr;
            if (ipv4Addr == null) {
                throw new NullPointerException("Property ipv4Addr must not be null");
            }
            return new OFBsnArpIdleVer13(xid, vlanVid, ipv4Addr);
        }
    }
}

