/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescProp;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientPortDescPropVer13;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFCalientPortDescStatsEntryVer13
implements OFCalientPortDescStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFCalientPortDescStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 40;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final MacAddress DEFAULT_HW_ADDR = MacAddress.NONE;
    private static final String DEFAULT_NAME = "";
    private static final long DEFAULT_CONFIG = 0L;
    private static final long DEFAULT_STATE = 0L;
    private static final List<OFCalientPortDescProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final OFPort portNo;
    private final MacAddress hwAddr;
    private final String name;
    private final long config;
    private final long state;
    private final List<OFCalientPortDescProp> properties;
    static final OFCalientPortDescStatsEntryVer13 DEFAULT = new OFCalientPortDescStatsEntryVer13(DEFAULT_PORT_NO, DEFAULT_HW_ADDR, "", 0L, 0L, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFCalientPortDescStatsEntryVer13Funnel FUNNEL = new OFCalientPortDescStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFCalientPortDescStatsEntryVer13(OFPort portNo, MacAddress hwAddr, String name, long config, long state, List<OFCalientPortDescProp> properties) {
        if (portNo == null) {
            throw new NullPointerException("OFCalientPortDescStatsEntryVer13: property portNo cannot be null");
        }
        if (hwAddr == null) {
            throw new NullPointerException("OFCalientPortDescStatsEntryVer13: property hwAddr cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFCalientPortDescStatsEntryVer13: property name cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFCalientPortDescStatsEntryVer13: property properties cannot be null");
        }
        this.portNo = portNo;
        this.hwAddr = hwAddr;
        this.name = name;
        this.config = config;
        this.state = state;
        this.properties = properties;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public MacAddress getHwAddr() {
        return this.hwAddr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getConfig() {
        return this.config;
    }

    @Override
    public long getState() {
        return this.state;
    }

    @Override
    public List<OFCalientPortDescProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFCalientPortDescStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFCalientPortDescStatsEntryVer13(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("hwAddr=").append(this.hwAddr);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("state=").append(this.state);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFCalientPortDescStatsEntryVer13 other = (OFCalientPortDescStatsEntryVer13)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.hwAddr == null ? other.hwAddr != null : !this.hwAddr.equals(other.hwAddr)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.config != other.config) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.hwAddr == null ? 0 : this.hwAddr.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * (int)(this.config ^ this.config >>> 32);
        result = 31 * (int)(this.state ^ this.state >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFCalientPortDescStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFCalientPortDescStatsEntryVer13 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            message.portNo.write4Bytes(bb);
            message.hwAddr.write6Bytes(bb);
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.name, 16);
            bb.writeInt(U32.t(message.config));
            bb.writeInt(U32.t(message.state));
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFCalientPortDescStatsEntryVer13Funnel
    implements Funnel<OFCalientPortDescStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFCalientPortDescStatsEntryVer13Funnel() {
        }

        public void funnel(OFCalientPortDescStatsEntryVer13 message, PrimitiveSink sink) {
            message.portNo.putTo(sink);
            message.hwAddr.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            sink.putLong(message.config);
            sink.putLong(message.state);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFCalientPortDescStatsEntry> {
        Reader() {
        }

        @Override
        public OFCalientPortDescStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 40) {
                throw new OFParseError("Wrong length: Expected to be >= 40, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            OFPort portNo = OFPort.read4Bytes(bb);
            MacAddress hwAddr = MacAddress.read6Bytes(bb);
            bb.skipBytes(2);
            String name = ChannelUtils.readFixedLengthString(bb, 16);
            long config = U32.f(bb.readInt());
            long state = U32.f(bb.readInt());
            List<OFCalientPortDescProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFCalientPortDescPropVer13.READER);
            OFCalientPortDescStatsEntryVer13 calientPortDescStatsEntryVer13 = new OFCalientPortDescStatsEntryVer13(portNo, hwAddr, name, config, state, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)calientPortDescStatsEntryVer13);
            }
            return calientPortDescStatsEntryVer13;
        }
    }

    static class Builder
    implements OFCalientPortDescStatsEntry.Builder {
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private long config;
        private boolean stateSet;
        private long state;
        private boolean propertiesSet;
        private List<OFCalientPortDescProp> properties;

        Builder() {
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public long getState() {
            return this.state;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setState(long state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public List<OFCalientPortDescProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setProperties(List<OFCalientPortDescProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFCalientPortDescStatsEntry build() {
            List<OFCalientPortDescProp> properties;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : DEFAULT_HW_ADDR;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : OFCalientPortDescStatsEntryVer13.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            long config = this.configSet ? this.config : 0L;
            long state = this.stateSet ? this.state : 0L;
            List<OFCalientPortDescProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFCalientPortDescStatsEntryVer13(portNo, hwAddr, name, config, state, properties);
        }
    }

    static class BuilderWithParent
    implements OFCalientPortDescStatsEntry.Builder {
        final OFCalientPortDescStatsEntryVer13 parentMessage;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private long config;
        private boolean stateSet;
        private long state;
        private boolean propertiesSet;
        private List<OFCalientPortDescProp> properties;

        BuilderWithParent(OFCalientPortDescStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public long getState() {
            return this.state;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setState(long state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public List<OFCalientPortDescProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFCalientPortDescStatsEntry.Builder setProperties(List<OFCalientPortDescProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFCalientPortDescStatsEntry build() {
            List properties;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : this.parentMessage.hwAddr;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            long config = this.configSet ? this.config : this.parentMessage.config;
            long state = this.stateSet ? this.state : this.parentMessage.state;
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFCalientPortDescStatsEntryVer13(portNo, hwAddr, name, config, state, properties);
        }
    }
}

