/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientPortDescStatsEntryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsReplyFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFCalientPortDescStatsReplyVer13
implements OFCalientPortDescStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFCalientPortDescStatsReplyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFCalientPortDescStatsEntry> DEFAULT_PORT_DESC = ImmutableList.of();
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final List<OFCalientPortDescStatsEntry> portDesc;
    static final OFCalientPortDescStatsReplyVer13 DEFAULT = new OFCalientPortDescStatsReplyVer13(0L, DEFAULT_FLAGS, DEFAULT_PORT_DESC);
    static final Reader READER = new Reader();
    static final OFCalientPortDescStatsReplyVer13Funnel FUNNEL = new OFCalientPortDescStatsReplyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFCalientPortDescStatsReplyVer13(long xid, Set<OFStatsReplyFlags> flags, List<OFCalientPortDescStatsEntry> portDesc) {
        if (flags == null) {
            throw new NullPointerException("OFCalientPortDescStatsReplyVer13: property flags cannot be null");
        }
        if (portDesc == null) {
            throw new NullPointerException("OFCalientPortDescStatsReplyVer13: property portDesc cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.portDesc = portDesc;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 8452440L;
    }

    @Override
    public long getSubtype() {
        return 1L;
    }

    @Override
    public List<OFCalientPortDescStatsEntry> getPortDesc() {
        return this.portDesc;
    }

    @Override
    public OFCalientPortDescStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFCalientPortDescStatsReplyVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("portDesc=").append(this.portDesc);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFCalientPortDescStatsReplyVer13 other = (OFCalientPortDescStatsReplyVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.portDesc == null ? other.portDesc != null : !this.portDesc.equals(other.portDesc));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.portDesc == null ? 0 : this.portDesc.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFCalientPortDescStatsReplyVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFCalientPortDescStatsReplyVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(19);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsReplyFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(8452440);
            bb.writeInt(1);
            ChannelUtils.writeList(bb, message.portDesc);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFCalientPortDescStatsReplyVer13Funnel
    implements Funnel<OFCalientPortDescStatsReplyVer13> {
        private static final long serialVersionUID = 1L;

        OFCalientPortDescStatsReplyVer13Funnel() {
        }

        public void funnel(OFCalientPortDescStatsReplyVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)19);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsReplyFlagsSerializerVer13.putTo(message.flags, sink);
            sink.putInt(8452440);
            sink.putInt(1);
            FunnelUtils.putList(message.portDesc, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFCalientPortDescStatsReply> {
        Reader() {
        }

        @Override
        public OFCalientPortDescStatsReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 8452440) {
                throw new OFParseError("Wrong experimenter: Expected=0x80f958L(0x80f958L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 1) {
                throw new OFParseError("Wrong subtype: Expected=0x1L(0x1L), got=" + subtype);
            }
            List<OFCalientPortDescStatsEntry> portDesc = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFCalientPortDescStatsEntryVer13.READER);
            OFCalientPortDescStatsReplyVer13 calientPortDescStatsReplyVer13 = new OFCalientPortDescStatsReplyVer13(xid, flags, portDesc);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)calientPortDescStatsReplyVer13);
            }
            return calientPortDescStatsReplyVer13;
        }
    }

    static class Builder
    implements OFCalientPortDescStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean portDescSet;
        private List<OFCalientPortDescStatsEntry> portDesc;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFCalientPortDescStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFCalientPortDescStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 8452440L;
        }

        @Override
        public long getSubtype() {
            return 1L;
        }

        @Override
        public List<OFCalientPortDescStatsEntry> getPortDesc() {
            return this.portDesc;
        }

        @Override
        public OFCalientPortDescStatsReply.Builder setPortDesc(List<OFCalientPortDescStatsEntry> portDesc) {
            this.portDesc = portDesc;
            this.portDescSet = true;
            return this;
        }

        @Override
        public OFCalientPortDescStatsReply build() {
            List<OFCalientPortDescStatsEntry> portDesc;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List<OFCalientPortDescStatsEntry> list = portDesc = this.portDescSet ? this.portDesc : DEFAULT_PORT_DESC;
            if (portDesc == null) {
                throw new NullPointerException("Property portDesc must not be null");
            }
            return new OFCalientPortDescStatsReplyVer13(xid, flags, portDesc);
        }
    }

    static class BuilderWithParent
    implements OFCalientPortDescStatsReply.Builder {
        final OFCalientPortDescStatsReplyVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean portDescSet;
        private List<OFCalientPortDescStatsEntry> portDesc;

        BuilderWithParent(OFCalientPortDescStatsReplyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFCalientPortDescStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFCalientPortDescStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 8452440L;
        }

        @Override
        public long getSubtype() {
            return 1L;
        }

        @Override
        public List<OFCalientPortDescStatsEntry> getPortDesc() {
            return this.portDesc;
        }

        @Override
        public OFCalientPortDescStatsReply.Builder setPortDesc(List<OFCalientPortDescStatsEntry> portDesc) {
            this.portDesc = portDesc;
            this.portDescSet = true;
            return this;
        }

        @Override
        public OFCalientPortDescStatsReply build() {
            List portDesc;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List list = portDesc = this.portDescSet ? this.portDesc : this.parentMessage.portDesc;
            if (portDesc == null) {
                throw new NullPointerException("Property portDesc must not be null");
            }
            return new OFCalientPortDescStatsReplyVer13(xid, flags, portDesc);
        }
    }
}

