/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnInnerEthSrc;
import org.projectfloodlight.openflow.types.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnInnerEthSrcVer13
implements OFOxmBsnInnerEthSrc {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnInnerEthSrcVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFOxmBsnInnerEthSrcVer13 DEFAULT = new OFOxmBsnInnerEthSrcVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnInnerEthSrcVer13Funnel FUNNEL = new OFOxmBsnInnerEthSrcVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnInnerEthSrcVer13(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnInnerEthSrcVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 208390L;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public MatchField<MacAddress> getMatchField() {
        return MatchField.BSN_INNER_ETH_SRC;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<MacAddress> getCanonical() {
        return this;
    }

    @Override
    public MacAddress getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnInnerEthSrc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnInnerEthSrcVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnInnerEthSrcVer13 other = (OFOxmBsnInnerEthSrcVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnInnerEthSrcVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmBsnInnerEthSrcVer13 message) {
            bb.writeInt(208390);
            message.value.write6Bytes(bb);
        }
    }

    static class OFOxmBsnInnerEthSrcVer13Funnel
    implements Funnel<OFOxmBsnInnerEthSrcVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnInnerEthSrcVer13Funnel() {
        }

        public void funnel(OFOxmBsnInnerEthSrcVer13 message, PrimitiveSink sink) {
            sink.putInt(208390);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnInnerEthSrc> {
        Reader() {
        }

        @Override
        public OFOxmBsnInnerEthSrc readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 208390) {
                throw new OFParseError("Wrong typeLen: Expected=0x32e06L(0x32e06L), got=" + typeLen);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFOxmBsnInnerEthSrcVer13 oxmBsnInnerEthSrcVer13 = new OFOxmBsnInnerEthSrcVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnInnerEthSrcVer13);
            }
            return oxmBsnInnerEthSrcVer13;
        }
    }

    static class Builder
    implements OFOxmBsnInnerEthSrc.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 208390L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInnerEthSrc.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.BSN_INNER_ETH_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnInnerEthSrc build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnInnerEthSrcVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnInnerEthSrc.Builder {
        final OFOxmBsnInnerEthSrcVer13 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFOxmBsnInnerEthSrcVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 208390L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInnerEthSrc.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.BSN_INNER_ETH_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnInnerEthSrc build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnInnerEthSrcVer13(value);
        }
    }
}

