/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmExpOduSigtype;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmExpOduSigtypeVer13
implements OFOxmExpOduSigtype {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmExpOduSigtypeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 9;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmExpOduSigtypeVer13 DEFAULT = new OFOxmExpOduSigtypeVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmExpOduSigtypeVer13Funnel FUNNEL = new OFOxmExpOduSigtypeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmExpOduSigtypeVer13(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmExpOduSigtypeVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 4294902785L;
    }

    @Override
    public long getExperimenter() {
        return 0xFF000007L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.EXP_ODU_SIGTYPE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmExpOduSigtype.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmExpOduSigtypeVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmExpOduSigtypeVer13 other = (OFOxmExpOduSigtypeVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmExpOduSigtypeVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmExpOduSigtypeVer13 message) {
            bb.writeInt(-64511);
            bb.writeInt(-16777209);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmExpOduSigtypeVer13Funnel
    implements Funnel<OFOxmExpOduSigtypeVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmExpOduSigtypeVer13Funnel() {
        }

        public void funnel(OFOxmExpOduSigtypeVer13 message, PrimitiveSink sink) {
            sink.putInt(-64511);
            sink.putInt(-16777209);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmExpOduSigtype> {
        Reader() {
        }

        @Override
        public OFOxmExpOduSigtype readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -64511) {
                throw new OFParseError("Wrong typeLen: Expected=0xffff0401L(0xffff0401L), got=" + typeLen);
            }
            int experimenter = bb.readInt();
            if (experimenter != -16777209) {
                throw new OFParseError("Wrong experimenter: Expected=0xff000007L(0xff000007L), got=" + experimenter);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmExpOduSigtypeVer13 oxmExpOduSigtypeVer13 = new OFOxmExpOduSigtypeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmExpOduSigtypeVer13);
            }
            return oxmExpOduSigtypeVer13;
        }
    }

    static class Builder
    implements OFOxmExpOduSigtype.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 4294902785L;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000007L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmExpOduSigtype.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.EXP_ODU_SIGTYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmExpOduSigtype build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmExpOduSigtypeVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmExpOduSigtype.Builder {
        final OFOxmExpOduSigtypeVer13 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmExpOduSigtypeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 4294902785L;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000007L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmExpOduSigtype.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.EXP_ODU_SIGTYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmExpOduSigtype build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmExpOduSigtypeVer13(value);
        }
    }
}

