/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNshSpi;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmNshSpiVer13
implements OFOxmNshSpi {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmNshSpiVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private final U32 value;
    static final OFOxmNshSpiVer13 DEFAULT = new OFOxmNshSpiVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmNshSpiVer13Funnel FUNNEL = new OFOxmNshSpiVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmNshSpiVer13(U32 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmNshSpiVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 84484L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U32> getMatchField() {
        return MatchField.NSH_SPI;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U32> getCanonical() {
        return this;
    }

    @Override
    public U32 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmNshSpi.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmNshSpiVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmNshSpiVer13 other = (OFOxmNshSpiVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmNshSpiVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmNshSpiVer13 message) {
            bb.writeInt(84484);
            bb.writeInt(message.value.getRaw());
        }
    }

    static class OFOxmNshSpiVer13Funnel
    implements Funnel<OFOxmNshSpiVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmNshSpiVer13Funnel() {
        }

        public void funnel(OFOxmNshSpiVer13 message, PrimitiveSink sink) {
            sink.putInt(84484);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmNshSpi> {
        Reader() {
        }

        @Override
        public OFOxmNshSpi readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 84484) {
                throw new OFParseError("Wrong typeLen: Expected=0x14a04L(0x14a04L), got=" + typeLen);
            }
            U32 value = U32.of(bb.readInt());
            OFOxmNshSpiVer13 oxmNshSpiVer13 = new OFOxmNshSpiVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmNshSpiVer13);
            }
            return oxmNshSpiVer13;
        }
    }

    static class Builder
    implements OFOxmNshSpi.Builder {
        private boolean valueSet;
        private U32 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 84484L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNshSpi.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.NSH_SPI;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmNshSpi build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNshSpiVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmNshSpi.Builder {
        final OFOxmNshSpiVer13 parentMessage;
        private boolean valueSet;
        private U32 value;

        BuilderWithParent(OFOxmNshSpiVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 84484L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNshSpi.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.NSH_SPI;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmNshSpi build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNshSpiVer13(value);
        }
    }
}

