/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdNiciraSetNshc2;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdNiciraSetNshc2Ver14
implements OFActionIdNiciraSetNshc2 {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdNiciraSetNshc2Ver14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 10;
    static final OFActionIdNiciraSetNshc2Ver14 DEFAULT = new OFActionIdNiciraSetNshc2Ver14();
    static final OFActionIdNiciraSetNshc2Ver14 INSTANCE = new OFActionIdNiciraSetNshc2Ver14();
    static final Reader READER = new Reader();
    static final OFActionIdNiciraSetNshc2Ver14Funnel FUNNEL = new OFActionIdNiciraSetNshc2Ver14Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdNiciraSetNshc2Ver14() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 35;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionIdNiciraSetNshc2.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdNiciraSetNshc2Ver14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdNiciraSetNshc2Ver14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdNiciraSetNshc2Ver14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionIdNiciraSetNshc2Ver14 message) {
            bb.writeShort(-1);
            bb.writeShort(10);
            bb.writeInt(8992);
            bb.writeShort(35);
        }
    }

    static class OFActionIdNiciraSetNshc2Ver14Funnel
    implements Funnel<OFActionIdNiciraSetNshc2Ver14> {
        private static final long serialVersionUID = 1L;

        OFActionIdNiciraSetNshc2Ver14Funnel() {
        }

        public void funnel(OFActionIdNiciraSetNshc2Ver14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)10);
            sink.putInt(8992);
            sink.putShort((short)35);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdNiciraSetNshc2> {
        Reader() {
        }

        @Override
        public OFActionIdNiciraSetNshc2 readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 35) {
                throw new OFParseError("Wrong subtype: Expected=0x23(0x23), got=" + subtype);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

