/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver14.OFAsyncGetReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFAsyncGetRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFAsyncSetVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBarrierReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBarrierRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBundleAddMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBundleCtrlMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFEchoReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFEchoRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFExperimenterVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFeaturesReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFeaturesRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFlowModVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFlowRemovedVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGetConfigReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGetConfigRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupModVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFHelloVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterModVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPacketInVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPacketOutVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPortModVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPortStatusVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFRequestforwardVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFRoleReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFRoleRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFRoleStatusVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFSetConfigVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFStatsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFTableModVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFTableStatusVer14;

abstract class OFMessageVer14 {
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFMessageVer14() {
    }

    static class Reader
    implements OFMessageReader<OFMessage> {
        Reader() {
        }

        @Override
        public OFMessage readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            bb.readerIndex(start);
            switch (type) {
                case 19: {
                    return OFStatsReplyVer14.READER.readFrom(bb);
                }
                case 18: {
                    return OFStatsRequestVer14.READER.readFrom(bb);
                }
                case 1: {
                    return OFErrorMsgVer14.READER.readFrom(bb);
                }
                case 21: {
                    return OFBarrierReplyVer14.READER.readFrom(bb);
                }
                case 20: {
                    return OFBarrierRequestVer14.READER.readFrom(bb);
                }
                case 4: {
                    return OFExperimenterVer14.READER.readFrom(bb);
                }
                case 3: {
                    return OFEchoReplyVer14.READER.readFrom(bb);
                }
                case 2: {
                    return OFEchoRequestVer14.READER.readFrom(bb);
                }
                case 6: {
                    return OFFeaturesReplyVer14.READER.readFrom(bb);
                }
                case 5: {
                    return OFFeaturesRequestVer14.READER.readFrom(bb);
                }
                case 14: {
                    return OFFlowModVer14.READER.readFrom(bb);
                }
                case 11: {
                    return OFFlowRemovedVer14.READER.readFrom(bb);
                }
                case 8: {
                    return OFGetConfigReplyVer14.READER.readFrom(bb);
                }
                case 7: {
                    return OFGetConfigRequestVer14.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloVer14.READER.readFrom(bb);
                }
                case 10: {
                    return OFPacketInVer14.READER.readFrom(bb);
                }
                case 13: {
                    return OFPacketOutVer14.READER.readFrom(bb);
                }
                case 16: {
                    return OFPortModVer14.READER.readFrom(bb);
                }
                case 12: {
                    return OFPortStatusVer14.READER.readFrom(bb);
                }
                case 9: {
                    return OFSetConfigVer14.READER.readFrom(bb);
                }
                case 17: {
                    return OFTableModVer14.READER.readFrom(bb);
                }
                case 15: {
                    return OFGroupModVer14.READER.readFrom(bb);
                }
                case 25: {
                    return OFRoleReplyVer14.READER.readFrom(bb);
                }
                case 24: {
                    return OFRoleRequestVer14.READER.readFrom(bb);
                }
                case 27: {
                    return OFAsyncGetReplyVer14.READER.readFrom(bb);
                }
                case 26: {
                    return OFAsyncGetRequestVer14.READER.readFrom(bb);
                }
                case 28: {
                    return OFAsyncSetVer14.READER.readFrom(bb);
                }
                case 29: {
                    return OFMeterModVer14.READER.readFrom(bb);
                }
                case 34: {
                    return OFBundleAddMsgVer14.READER.readFrom(bb);
                }
                case 33: {
                    return OFBundleCtrlMsgVer14.READER.readFrom(bb);
                }
                case 32: {
                    return OFRequestforwardVer14.READER.readFrom(bb);
                }
                case 30: {
                    return OFRoleStatusVer14.READER.readFrom(bb);
                }
                case 31: {
                    return OFTableStatusVer14.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator type of class OFMessageVer14: " + type);
        }
    }
}

