/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFMeterFeatures;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterFeaturesVer14
implements OFMeterFeatures {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterFeaturesVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final long DEFAULT_MAX_METER = 0L;
    private static final long DEFAULT_BAND_TYPES = 0L;
    private static final long DEFAULT_CAPABILITIES = 0L;
    private static final short DEFAULT_MAX_BANDS = 0;
    private static final short DEFAULT_MAX_COLOR = 0;
    private final long maxMeter;
    private final long bandTypes;
    private final long capabilities;
    private final short maxBands;
    private final short maxColor;
    static final OFMeterFeaturesVer14 DEFAULT = new OFMeterFeaturesVer14(0L, 0L, 0L, 0, 0);
    static final Reader READER = new Reader();
    static final OFMeterFeaturesVer14Funnel FUNNEL = new OFMeterFeaturesVer14Funnel();
    static final Writer WRITER = new Writer();

    OFMeterFeaturesVer14(long maxMeter, long bandTypes, long capabilities, short maxBands, short maxColor) {
        this.maxMeter = maxMeter;
        this.bandTypes = bandTypes;
        this.capabilities = capabilities;
        this.maxBands = maxBands;
        this.maxColor = maxColor;
    }

    @Override
    public long getMaxMeter() {
        return this.maxMeter;
    }

    @Override
    public long getBandTypes() {
        return this.bandTypes;
    }

    @Override
    public long getCapabilities() {
        return this.capabilities;
    }

    @Override
    public short getMaxBands() {
        return this.maxBands;
    }

    @Override
    public short getMaxColor() {
        return this.maxColor;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFMeterFeatures.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterFeaturesVer14(");
        b.append("maxMeter=").append(this.maxMeter);
        b.append(", ");
        b.append("bandTypes=").append(this.bandTypes);
        b.append(", ");
        b.append("capabilities=").append(this.capabilities);
        b.append(", ");
        b.append("maxBands=").append(this.maxBands);
        b.append(", ");
        b.append("maxColor=").append(this.maxColor);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterFeaturesVer14 other = (OFMeterFeaturesVer14)obj;
        if (this.maxMeter != other.maxMeter) {
            return false;
        }
        if (this.bandTypes != other.bandTypes) {
            return false;
        }
        if (this.capabilities != other.capabilities) {
            return false;
        }
        if (this.maxBands != other.maxBands) {
            return false;
        }
        return this.maxColor == other.maxColor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.maxMeter ^ this.maxMeter >>> 32);
        result = 31 * (int)(this.bandTypes ^ this.bandTypes >>> 32);
        result = 31 * (int)(this.capabilities ^ this.capabilities >>> 32);
        result = 31 * result + this.maxBands;
        result = 31 * result + this.maxColor;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterFeaturesVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFMeterFeaturesVer14 message) {
            bb.writeInt(U32.t(message.maxMeter));
            bb.writeInt(U32.t(message.bandTypes));
            bb.writeInt(U32.t(message.capabilities));
            bb.writeByte((int)U8.t(message.maxBands));
            bb.writeByte((int)U8.t(message.maxColor));
            bb.writeZero(2);
        }
    }

    static class OFMeterFeaturesVer14Funnel
    implements Funnel<OFMeterFeaturesVer14> {
        private static final long serialVersionUID = 1L;

        OFMeterFeaturesVer14Funnel() {
        }

        public void funnel(OFMeterFeaturesVer14 message, PrimitiveSink sink) {
            sink.putLong(message.maxMeter);
            sink.putLong(message.bandTypes);
            sink.putLong(message.capabilities);
            sink.putShort(message.maxBands);
            sink.putShort(message.maxColor);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterFeatures> {
        Reader() {
        }

        @Override
        public OFMeterFeatures readFrom(ChannelBuffer bb) throws OFParseError {
            long maxMeter = U32.f(bb.readInt());
            long bandTypes = U32.f(bb.readInt());
            long capabilities = U32.f(bb.readInt());
            short maxBands = U8.f(bb.readByte());
            short maxColor = U8.f(bb.readByte());
            bb.skipBytes(2);
            OFMeterFeaturesVer14 meterFeaturesVer14 = new OFMeterFeaturesVer14(maxMeter, bandTypes, capabilities, maxBands, maxColor);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterFeaturesVer14);
            }
            return meterFeaturesVer14;
        }
    }

    static class Builder
    implements OFMeterFeatures.Builder {
        private boolean maxMeterSet;
        private long maxMeter;
        private boolean bandTypesSet;
        private long bandTypes;
        private boolean capabilitiesSet;
        private long capabilities;
        private boolean maxBandsSet;
        private short maxBands;
        private boolean maxColorSet;
        private short maxColor;

        Builder() {
        }

        @Override
        public long getMaxMeter() {
            return this.maxMeter;
        }

        @Override
        public OFMeterFeatures.Builder setMaxMeter(long maxMeter) {
            this.maxMeter = maxMeter;
            this.maxMeterSet = true;
            return this;
        }

        @Override
        public long getBandTypes() {
            return this.bandTypes;
        }

        @Override
        public OFMeterFeatures.Builder setBandTypes(long bandTypes) {
            this.bandTypes = bandTypes;
            this.bandTypesSet = true;
            return this;
        }

        @Override
        public long getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFMeterFeatures.Builder setCapabilities(long capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public short getMaxBands() {
            return this.maxBands;
        }

        @Override
        public OFMeterFeatures.Builder setMaxBands(short maxBands) {
            this.maxBands = maxBands;
            this.maxBandsSet = true;
            return this;
        }

        @Override
        public short getMaxColor() {
            return this.maxColor;
        }

        @Override
        public OFMeterFeatures.Builder setMaxColor(short maxColor) {
            this.maxColor = maxColor;
            this.maxColorSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFMeterFeatures build() {
            long maxMeter = this.maxMeterSet ? this.maxMeter : 0L;
            long bandTypes = this.bandTypesSet ? this.bandTypes : 0L;
            long capabilities = this.capabilitiesSet ? this.capabilities : 0L;
            short maxBands = this.maxBandsSet ? this.maxBands : (short)0;
            short maxColor = this.maxColorSet ? this.maxColor : (short)0;
            return new OFMeterFeaturesVer14(maxMeter, bandTypes, capabilities, maxBands, maxColor);
        }
    }

    static class BuilderWithParent
    implements OFMeterFeatures.Builder {
        final OFMeterFeaturesVer14 parentMessage;
        private boolean maxMeterSet;
        private long maxMeter;
        private boolean bandTypesSet;
        private long bandTypes;
        private boolean capabilitiesSet;
        private long capabilities;
        private boolean maxBandsSet;
        private short maxBands;
        private boolean maxColorSet;
        private short maxColor;

        BuilderWithParent(OFMeterFeaturesVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getMaxMeter() {
            return this.maxMeter;
        }

        @Override
        public OFMeterFeatures.Builder setMaxMeter(long maxMeter) {
            this.maxMeter = maxMeter;
            this.maxMeterSet = true;
            return this;
        }

        @Override
        public long getBandTypes() {
            return this.bandTypes;
        }

        @Override
        public OFMeterFeatures.Builder setBandTypes(long bandTypes) {
            this.bandTypes = bandTypes;
            this.bandTypesSet = true;
            return this;
        }

        @Override
        public long getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFMeterFeatures.Builder setCapabilities(long capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public short getMaxBands() {
            return this.maxBands;
        }

        @Override
        public OFMeterFeatures.Builder setMaxBands(short maxBands) {
            this.maxBands = maxBands;
            this.maxBandsSet = true;
            return this;
        }

        @Override
        public short getMaxColor() {
            return this.maxColor;
        }

        @Override
        public OFMeterFeatures.Builder setMaxColor(short maxColor) {
            this.maxColor = maxColor;
            this.maxColorSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFMeterFeatures build() {
            long maxMeter = this.maxMeterSet ? this.maxMeter : this.parentMessage.maxMeter;
            long bandTypes = this.bandTypesSet ? this.bandTypes : this.parentMessage.bandTypes;
            long capabilities = this.capabilitiesSet ? this.capabilities : this.parentMessage.capabilities;
            short maxBands = this.maxBandsSet ? this.maxBands : this.parentMessage.maxBands;
            short maxColor = this.maxColorSet ? this.maxColor : this.parentMessage.maxColor;
            return new OFMeterFeaturesVer14(maxMeter, bandTypes, capabilities, maxBands, maxColor);
        }
    }
}

