/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmArpOp;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmArpOpVer14
implements OFOxmArpOp {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmArpOpVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final ArpOpcode DEFAULT_VALUE = ArpOpcode.NONE;
    private final ArpOpcode value;
    static final OFOxmArpOpVer14 DEFAULT = new OFOxmArpOpVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmArpOpVer14Funnel FUNNEL = new OFOxmArpOpVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmArpOpVer14(ArpOpcode value) {
        if (value == null) {
            throw new NullPointerException("OFOxmArpOpVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147494402L;
    }

    @Override
    public ArpOpcode getValue() {
        return this.value;
    }

    @Override
    public MatchField<ArpOpcode> getMatchField() {
        return MatchField.ARP_OP;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<ArpOpcode> getCanonical() {
        return this;
    }

    @Override
    public ArpOpcode getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmArpOp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmArpOpVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmArpOpVer14 other = (OFOxmArpOpVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmArpOpVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmArpOpVer14 message) {
            bb.writeInt(-2147472894);
            message.value.write2Bytes(bb);
        }
    }

    static class OFOxmArpOpVer14Funnel
    implements Funnel<OFOxmArpOpVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmArpOpVer14Funnel() {
        }

        public void funnel(OFOxmArpOpVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147472894);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmArpOp> {
        Reader() {
        }

        @Override
        public OFOxmArpOp readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147472894) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002a02L(0x80002a02L), got=" + typeLen);
            }
            ArpOpcode value = ArpOpcode.read2Bytes(bb);
            OFOxmArpOpVer14 oxmArpOpVer14 = new OFOxmArpOpVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmArpOpVer14);
            }
            return oxmArpOpVer14;
        }
    }

    static class Builder
    implements OFOxmArpOp.Builder {
        private boolean valueSet;
        private ArpOpcode value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147494402L;
        }

        @Override
        public ArpOpcode getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpOp.Builder setValue(ArpOpcode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ArpOpcode> getMatchField() {
            return MatchField.ARP_OP;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ArpOpcode> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public ArpOpcode getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmArpOp build() {
            ArpOpcode value;
            ArpOpcode arpOpcode = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmArpOpVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmArpOp.Builder {
        final OFOxmArpOpVer14 parentMessage;
        private boolean valueSet;
        private ArpOpcode value;

        BuilderWithParent(OFOxmArpOpVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147494402L;
        }

        @Override
        public ArpOpcode getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpOp.Builder setValue(ArpOpcode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ArpOpcode> getMatchField() {
            return MatchField.ARP_OP;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ArpOpcode> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public ArpOpcode getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmArpOp build() {
            ArpOpcode value;
            ArpOpcode arpOpcode = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmArpOpVer14(value);
        }
    }
}

