/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortModPropEthernet;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortModPropEthernetVer14
implements OFPortModPropEthernet {
    private static final Logger logger = LoggerFactory.getLogger(OFPortModPropEthernetVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_ADVERTISE = 0L;
    private final long advertise;
    static final OFPortModPropEthernetVer14 DEFAULT = new OFPortModPropEthernetVer14(0L);
    static final Reader READER = new Reader();
    static final OFPortModPropEthernetVer14Funnel FUNNEL = new OFPortModPropEthernetVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortModPropEthernetVer14(long advertise) {
        this.advertise = advertise;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public long getAdvertise() {
        return this.advertise;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortModPropEthernet.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortModPropEthernetVer14(");
        b.append("advertise=").append(this.advertise);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortModPropEthernetVer14 other = (OFPortModPropEthernetVer14)obj;
        return this.advertise == other.advertise;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.advertise ^ this.advertise >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortModPropEthernetVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortModPropEthernetVer14 message) {
            bb.writeShort(0);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.advertise));
        }
    }

    static class OFPortModPropEthernetVer14Funnel
    implements Funnel<OFPortModPropEthernetVer14> {
        private static final long serialVersionUID = 1L;

        OFPortModPropEthernetVer14Funnel() {
        }

        public void funnel(OFPortModPropEthernetVer14 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)8);
            sink.putLong(message.advertise);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortModPropEthernet> {
        Reader() {
        }

        @Override
        public OFPortModPropEthernet readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long advertise = U32.f(bb.readInt());
            OFPortModPropEthernetVer14 portModPropEthernetVer14 = new OFPortModPropEthernetVer14(advertise);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portModPropEthernetVer14);
            }
            return portModPropEthernetVer14;
        }
    }

    static class Builder
    implements OFPortModPropEthernet.Builder {
        private boolean advertiseSet;
        private long advertise;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public long getAdvertise() {
            return this.advertise;
        }

        @Override
        public OFPortModPropEthernet.Builder setAdvertise(long advertise) {
            this.advertise = advertise;
            this.advertiseSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortModPropEthernet build() {
            long advertise = this.advertiseSet ? this.advertise : 0L;
            return new OFPortModPropEthernetVer14(advertise);
        }
    }

    static class BuilderWithParent
    implements OFPortModPropEthernet.Builder {
        final OFPortModPropEthernetVer14 parentMessage;
        private boolean advertiseSet;
        private long advertise;

        BuilderWithParent(OFPortModPropEthernetVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public long getAdvertise() {
            return this.advertise;
        }

        @Override
        public OFPortModPropEthernet.Builder setAdvertise(long advertise) {
            this.advertise = advertise;
            this.advertiseSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortModPropEthernet build() {
            long advertise = this.advertiseSet ? this.advertise : this.parentMessage.advertise;
            return new OFPortModPropEthernetVer14(advertise);
        }
    }
}

