/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedLongs;
import java.math.BigInteger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.Writeable;
import org.projectfloodlight.openflow.types.HashValue;
import org.projectfloodlight.openflow.types.HashValueUtils;
import org.projectfloodlight.openflow.types.OFValueType;

public class U64
implements Writeable,
OFValueType<U64>,
HashValue<U64> {
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;
    private static final long ZERO_VAL = 0L;
    public static final U64 ZERO = new U64(0L);
    private static final long NO_MASK_VAL = -1L;
    public static final U64 NO_MASK = new U64(-1L);
    public static final U64 FULL_MASK = ZERO;
    private final long raw;
    public static final Reader READER = new Reader();

    protected U64(long raw) {
        this.raw = raw;
    }

    public static U64 of(long raw) {
        return U64.ofRaw(raw);
    }

    public static U64 ofRaw(long raw) {
        if (raw == 0L) {
            return ZERO;
        }
        return new U64(raw);
    }

    public static U64 parseHex(String hex) {
        return new U64(new BigInteger(hex, 16).longValue());
    }

    public long getValue() {
        return this.raw;
    }

    public BigInteger getBigInteger() {
        BigInteger bigInt = BigInteger.valueOf(this.raw & Long.MAX_VALUE);
        if (this.raw < 0L) {
            bigInt = bigInt.setBit(63);
        }
        return bigInt;
    }

    public String toString() {
        return String.format("0x%016x", this.raw);
    }

    public static BigInteger f(long value) {
        BigInteger bigInt = BigInteger.valueOf(value & Long.MAX_VALUE);
        if (value < 0L) {
            bigInt = bigInt.setBit(63);
        }
        return bigInt;
    }

    public static long t(BigInteger l) {
        return l.longValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.raw ^ this.raw >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        U64 other = (U64)obj;
        return this.raw == other.raw;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public U64 applyMask(U64 mask) {
        return this.and(mask);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        bb.writeLong(this.raw);
    }

    @Override
    public int compareTo(U64 o) {
        return UnsignedLongs.compare((long)this.raw, (long)o.raw);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putLong(this.raw);
    }

    @Override
    public U64 inverse() {
        return U64.of(this.raw ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public U64 or(U64 other) {
        return U64.of(this.raw | other.raw);
    }

    @Override
    public U64 and(U64 other) {
        return U64.ofRaw(this.raw & other.raw);
    }

    @Override
    public U64 xor(U64 other) {
        return U64.of(this.raw ^ other.raw);
    }

    @Override
    public U64 add(U64 other) {
        return U64.of(this.raw + other.raw);
    }

    @Override
    public U64 subtract(U64 other) {
        return U64.of(this.raw - other.raw);
    }

    @Override
    public int prefixBits(int numBits) {
        return HashValueUtils.prefixBits(this.raw, numBits);
    }

    @Override
    public HashValue.Builder<U64> builder() {
        return new U64Builder(this.raw);
    }

    static class U64Builder
    implements HashValue.Builder<U64> {
        long raw;

        public U64Builder(long raw) {
            this.raw = raw;
        }

        @Override
        public HashValue.Builder<U64> add(U64 other) {
            this.raw += other.raw;
            return this;
        }

        @Override
        public HashValue.Builder<U64> subtract(U64 other) {
            this.raw -= other.raw;
            return this;
        }

        @Override
        public HashValue.Builder<U64> invert() {
            this.raw ^= 0xFFFFFFFFFFFFFFFFL;
            return this;
        }

        @Override
        public HashValue.Builder<U64> or(U64 other) {
            this.raw |= other.raw;
            return this;
        }

        @Override
        public HashValue.Builder<U64> and(U64 other) {
            this.raw &= other.raw;
            return this;
        }

        @Override
        public HashValue.Builder<U64> xor(U64 other) {
            this.raw ^= other.raw;
            return this;
        }

        @Override
        public U64 build() {
            return U64.of(this.raw);
        }
    }

    private static class Reader
    implements OFMessageReader<U64> {
        private Reader() {
        }

        @Override
        public U64 readFrom(ChannelBuffer bb) throws OFParseError {
            return U64.ofRaw(bb.readLong());
        }
    }
}

