/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Shorts;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;

public class VlanVid
implements OFValueType<VlanVid> {
    private static final short VALIDATION_MASK = 4095;
    private static final short ZERO_VAL = 0;
    static final int LENGTH = 2;
    public static final VlanVid ZERO = new VlanVid(0);
    public static final VlanVid NO_MASK = new VlanVid(-1);
    public static final VlanVid FULL_MASK = ZERO;
    private final short vid;
    private volatile byte[] bytesCache = null;

    private VlanVid(short vid) {
        this.vid = vid;
    }

    public static VlanVid ofVlan(int vid) {
        if (vid == VlanVid.NO_MASK.vid) {
            return NO_MASK;
        }
        if ((vid & 0xFFF) != vid) {
            throw new IllegalArgumentException(String.format("Illegal VLAN value: %x", vid));
        }
        return new VlanVid((short)vid);
    }

    public short getVlan() {
        return this.vid;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VlanVid)) {
            return false;
        }
        VlanVid other = (VlanVid)obj;
        return other.vid == this.vid;
    }

    public int hashCode() {
        int prime = 13873;
        return this.vid * prime;
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.vid);
    }

    @Override
    public int getLength() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        if (this.bytesCache == null) {
            VlanVid vlanVid = this;
            synchronized (vlanVid) {
                if (this.bytesCache == null) {
                    this.bytesCache = new byte[]{(byte)(this.vid >>> 8 & 0xFF), (byte)(this.vid >>> 0 & 0xFF)};
                }
            }
        }
        return Arrays.copyOf(this.bytesCache, this.bytesCache.length);
    }

    public void write2Bytes(ChannelBuffer c) {
        c.writeShort((int)this.vid);
    }

    public void write2BytesOF10(ChannelBuffer c) {
        c.writeShort((int)this.getVlan());
    }

    public static VlanVid read2Bytes(ChannelBuffer c) throws OFParseError {
        return VlanVid.ofVlan(c.readShort());
    }

    @Override
    public VlanVid applyMask(VlanVid mask) {
        return VlanVid.ofVlan((short)(this.vid & mask.vid));
    }

    @Override
    public int compareTo(VlanVid o) {
        return Shorts.compare((short)this.vid, (short)o.vid);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putShort(this.vid);
    }
}

