/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.util;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.projectfloodlight.openflow.protocol.OFBsnPktinFlag;
import org.projectfloodlight.openflow.protocol.OFPacketIn;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnPktinFlagSerializerVer13;
import org.projectfloodlight.openflow.types.OFMetadata;
import org.projectfloodlight.openflow.types.U64;

public class MultiplePktInReasonUtil {
    private MultiplePktInReasonUtil() {
    }

    public static Set<OFBsnPktinFlag> getOFBsnPktinFlags(OFPacketIn pktIn) {
        if (pktIn.getVersion().compareTo(OFVersion.OF_13) < 0) {
            throw new IllegalArgumentException("multiple pkt in reasons are only supported by BVS using openflow version >= 1.3");
        }
        Match match = pktIn.getMatch();
        if (match == null) {
            return ImmutableSet.of();
        }
        OFMetadata metaData = match.get(MatchField.METADATA);
        if (metaData == null) {
            return ImmutableSet.of();
        }
        U64 metaDataValue = metaData.getValue();
        if (metaDataValue == null) {
            return ImmutableSet.of();
        }
        return OFBsnPktinFlagSerializerVer13.ofWireValue(metaDataValue.getValue());
    }
}

