/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowDelete;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFlowDeleteVer13;
import org.projectfloodlight.openflow.types.CircuitSignalID;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.IpProtocol;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.OduSignalID;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.types.U8;

public class OFFlowDeleteVer13Test {
    OFFactory factory;
    static final byte[] FLOW_DELETE_SERIALIZED = new byte[]{4, 14, 0, -72, 18, 52, 86, 120, -2, -36, -70, -104, 118, 84, 50, 16, -1, 0, -1, 0, -1, 0, -1, 0, 3, 3, 0, 5, 0, 10, 23, 112, 0, 0, 0, 50, 0, 0, 0, 6, 0, 0, 0, 8, 0, 0, 0, 0, 0, 1, 0, 119, -128, 0, 1, 8, 0, 0, 0, 4, 0, 0, 0, 5, -128, 0, 10, 2, -122, -35, -128, 0, 20, 1, 6, -128, 0, 53, 32, 28, -54, -2, 28, -79, 16, 28, 0, 0, 40, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -16, -1, -1, 28, 44, 60, 0, 0, 0, 0, 0, -1, -1, 6, 16, -1, 0, 0, 7, 85, 85, 0, 80, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, -1, -1, 4, 1, -1, 0, 0, 7, 8, -1, -1, 10, 6, -1, 0, 0, 7, 2, 1, 0, 4, 0, 1, -1, -1, 8, 1, -1, 0, 0, 7, 22, 0, 0, 1, 0, 8, 4, 0, 0, 0, 0, 1, 0, 8, 7, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFlowDelete.Builder builder = this.factory.buildFlowDelete();
        builder.setXid(305419896L).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setCookieMask(U64.parseHex((String)"FF00FF00FF00FF00")).setTableId(TableId.of((int)3)).setIdleTimeout(5).setHardTimeout(10).setPriority(6000).setBufferId(OFBufferId.of((int)50)).setOutPort(OFPort.of((int)6)).setOutGroup(OFGroup.of((int)8)).setFlags((Set)ImmutableSet.of()).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv6).setExact(MatchField.IP_PROTO, (OFValueType)IpProtocol.TCP).setMasked(MatchField.IPV6_SRC, (OFValueType)IPv6Address.of((long)2074749977540697088L, (long)0x28000000000000L), (OFValueType)IPv6Address.of((long)-983041L, (long)2030063502734917632L)).setExact(MatchField.EXP_ODU_SIG_ID, (OFValueType)new OduSignalID(21845, 80, new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1})).setExact(MatchField.EXP_ODU_SIGTYPE, (OFValueType)U8.of((short)8)).setExact(MatchField.EXP_OCH_SIG_ID, (OFValueType)new CircuitSignalID(2, 1, 4, 1)).setExact(MatchField.EXP_OCH_SIGTYPE, (OFValueType)U8.of((short)22)).build()).setInstructions((List)ImmutableList.of((Object)this.factory.instructions().gotoTable(TableId.of((int)4)), (Object)this.factory.instructions().gotoTable(TableId.of((int)7))));
        OFFlowDelete flowDelete = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        flowDelete.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_DELETE_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFlowDelete.Builder builder = this.factory.buildFlowDelete();
        builder.setXid(305419896L).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setCookieMask(U64.parseHex((String)"FF00FF00FF00FF00")).setTableId(TableId.of((int)3)).setIdleTimeout(5).setHardTimeout(10).setPriority(6000).setBufferId(OFBufferId.of((int)50)).setOutPort(OFPort.of((int)6)).setOutGroup(OFGroup.of((int)8)).setFlags((Set)ImmutableSet.of()).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv6).setExact(MatchField.IP_PROTO, (OFValueType)IpProtocol.TCP).setMasked(MatchField.IPV6_SRC, (OFValueType)IPv6Address.of((long)2074749977540697088L, (long)0x28000000000000L), (OFValueType)IPv6Address.of((long)-983041L, (long)2030063502734917632L)).setExact(MatchField.EXP_ODU_SIG_ID, (OFValueType)new OduSignalID(21845, 80, new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1})).setExact(MatchField.EXP_ODU_SIGTYPE, (OFValueType)U8.of((short)8)).setExact(MatchField.EXP_OCH_SIG_ID, (OFValueType)new CircuitSignalID(2, 1, 4, 1)).setExact(MatchField.EXP_OCH_SIGTYPE, (OFValueType)U8.of((short)22)).build()).setInstructions((List)ImmutableList.of((Object)this.factory.instructions().gotoTable(TableId.of((int)4)), (Object)this.factory.instructions().gotoTable(TableId.of((int)7))));
        OFFlowDelete flowDeleteBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])FLOW_DELETE_SERIALIZED);
        OFFlowDelete flowDeleteRead = OFFlowDeleteVer13.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_DELETE_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)flowDeleteBuilt, (Object)flowDeleteRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])FLOW_DELETE_SERIALIZED);
        OFFlowDelete flowDelete = OFFlowDeleteVer13.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_DELETE_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        flowDelete.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_DELETE_SERIALIZED));
    }
}

