/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.types.DatapathId;
import org.projectfloodlight.openflow.types.MacAddress;

public class DatapathIdTest {
    byte[][] testDpids = new byte[][]{{0, 0, 1, 2, 3, 4, 5, 6}, {0, 0, -128, 0, 0, 0, 0, 1}, {0, 0, -1, -1, -1, -1, -1, -1}};
    String[] testStrings = new String[]{"00:00:01:02:03:04:05:06", "00:00:80:00:00:00:00:01", "00:00:ff:ff:ff:ff:ff:ff"};
    long[] testInts = new long[]{1108152157446L, 0x800000000001L, 0xFFFFFFFFFFFFL};

    @Test
    public void testOfString() {
        for (int i = 0; i < this.testDpids.length; ++i) {
            DatapathId dpid = DatapathId.of((String)this.testStrings[i]);
            Assert.assertEquals((long)this.testInts[i], (long)dpid.getLong());
            Assert.assertArrayEquals((byte[])this.testDpids[i], (byte[])dpid.getBytes());
            Assert.assertEquals((Object)this.testStrings[i], (Object)dpid.toString());
        }
    }

    @Test
    public void testOfByteArray() {
        for (int i = 0; i < this.testDpids.length; ++i) {
            DatapathId dpid = DatapathId.of((byte[])this.testDpids[i]);
            Assert.assertEquals((String)("error checking long representation of " + Arrays.toString(this.testDpids[i]) + "(should be " + Long.toHexString(this.testInts[i]) + ")"), (long)this.testInts[i], (long)dpid.getLong());
            Assert.assertArrayEquals((byte[])this.testDpids[i], (byte[])dpid.getBytes());
            Assert.assertEquals((Object)this.testStrings[i], (Object)dpid.toString());
        }
    }

    @Test
    public void testOfMacAddress() {
        for (String s : this.testStrings) {
            MacAddress mac = MacAddress.of((String)s.replaceFirst("00:00:", ""));
            DatapathId candidateDpid = DatapathId.of((MacAddress)mac);
            DatapathId actualDpid = DatapathId.of((String)s);
            Assert.assertThat((Object)candidateDpid.equals((Object)actualDpid), (Matcher)Matchers.is((Object)true));
        }
    }
}

