/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnInterface;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnInterfaceVer10
implements OFBsnInterface {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnInterfaceVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 32;
    private static final MacAddress DEFAULT_HW_ADDR = MacAddress.NONE;
    private static final String DEFAULT_NAME = "";
    private static final IPv4Address DEFAULT_IPV4_ADDR = IPv4Address.NONE;
    private static final IPv4Address DEFAULT_IPV4_NETMASK = IPv4Address.NONE;
    private final MacAddress hwAddr;
    private final String name;
    private final IPv4Address ipv4Addr;
    private final IPv4Address ipv4Netmask;
    static final OFBsnInterfaceVer10 DEFAULT = new OFBsnInterfaceVer10(DEFAULT_HW_ADDR, "", DEFAULT_IPV4_ADDR, DEFAULT_IPV4_NETMASK);
    static final Reader READER = new Reader();
    static final OFBsnInterfaceVer10Funnel FUNNEL = new OFBsnInterfaceVer10Funnel();
    static final Writer WRITER = new Writer();

    OFBsnInterfaceVer10(MacAddress hwAddr, String name, IPv4Address ipv4Addr, IPv4Address ipv4Netmask) {
        if (hwAddr == null) {
            throw new NullPointerException("OFBsnInterfaceVer10: property hwAddr cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFBsnInterfaceVer10: property name cannot be null");
        }
        if (ipv4Addr == null) {
            throw new NullPointerException("OFBsnInterfaceVer10: property ipv4Addr cannot be null");
        }
        if (ipv4Netmask == null) {
            throw new NullPointerException("OFBsnInterfaceVer10: property ipv4Netmask cannot be null");
        }
        this.hwAddr = hwAddr;
        this.name = name;
        this.ipv4Addr = ipv4Addr;
        this.ipv4Netmask = ipv4Netmask;
    }

    @Override
    public MacAddress getHwAddr() {
        return this.hwAddr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IPv4Address getIpv4Addr() {
        return this.ipv4Addr;
    }

    @Override
    public IPv4Address getIpv4Netmask() {
        return this.ipv4Netmask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFBsnInterface.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnInterfaceVer10(");
        b.append("hwAddr=").append(this.hwAddr);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("ipv4Addr=").append(this.ipv4Addr);
        b.append(", ");
        b.append("ipv4Netmask=").append(this.ipv4Netmask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnInterfaceVer10 other = (OFBsnInterfaceVer10)obj;
        if (this.hwAddr == null ? other.hwAddr != null : !this.hwAddr.equals(other.hwAddr)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.ipv4Addr == null ? other.ipv4Addr != null : !this.ipv4Addr.equals(other.ipv4Addr)) {
            return false;
        }
        return !(this.ipv4Netmask == null ? other.ipv4Netmask != null : !this.ipv4Netmask.equals(other.ipv4Netmask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hwAddr == null ? 0 : this.hwAddr.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.ipv4Addr == null ? 0 : this.ipv4Addr.hashCode());
        result = 31 * result + (this.ipv4Netmask == null ? 0 : this.ipv4Netmask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnInterfaceVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnInterfaceVer10 message) {
            message.hwAddr.write6Bytes(bb);
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.name, 16);
            message.ipv4Addr.write4Bytes(bb);
            message.ipv4Netmask.write4Bytes(bb);
        }
    }

    static class OFBsnInterfaceVer10Funnel
    implements Funnel<OFBsnInterfaceVer10> {
        private static final long serialVersionUID = 1L;

        OFBsnInterfaceVer10Funnel() {
        }

        public void funnel(OFBsnInterfaceVer10 message, PrimitiveSink sink) {
            message.hwAddr.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            message.ipv4Addr.putTo(sink);
            message.ipv4Netmask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnInterface> {
        Reader() {
        }

        @Override
        public OFBsnInterface readFrom(ChannelBuffer bb) throws OFParseError {
            MacAddress hwAddr = MacAddress.read6Bytes(bb);
            bb.skipBytes(2);
            String name = ChannelUtils.readFixedLengthString(bb, 16);
            IPv4Address ipv4Addr = IPv4Address.read4Bytes(bb);
            IPv4Address ipv4Netmask = IPv4Address.read4Bytes(bb);
            OFBsnInterfaceVer10 bsnInterfaceVer10 = new OFBsnInterfaceVer10(hwAddr, name, ipv4Addr, ipv4Netmask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnInterfaceVer10);
            }
            return bsnInterfaceVer10;
        }
    }

    static class Builder
    implements OFBsnInterface.Builder {
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean ipv4AddrSet;
        private IPv4Address ipv4Addr;
        private boolean ipv4NetmaskSet;
        private IPv4Address ipv4Netmask;

        Builder() {
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFBsnInterface.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFBsnInterface.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Addr() {
            return this.ipv4Addr;
        }

        @Override
        public OFBsnInterface.Builder setIpv4Addr(IPv4Address ipv4Addr) {
            this.ipv4Addr = ipv4Addr;
            this.ipv4AddrSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Netmask() {
            return this.ipv4Netmask;
        }

        @Override
        public OFBsnInterface.Builder setIpv4Netmask(IPv4Address ipv4Netmask) {
            this.ipv4Netmask = ipv4Netmask;
            this.ipv4NetmaskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFBsnInterface build() {
            IPv4Address ipv4Netmask;
            IPv4Address ipv4Addr;
            String name;
            MacAddress hwAddr;
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : DEFAULT_HW_ADDR;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : OFBsnInterfaceVer10.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            IPv4Address iPv4Address = ipv4Addr = this.ipv4AddrSet ? this.ipv4Addr : DEFAULT_IPV4_ADDR;
            if (ipv4Addr == null) {
                throw new NullPointerException("Property ipv4Addr must not be null");
            }
            IPv4Address iPv4Address2 = ipv4Netmask = this.ipv4NetmaskSet ? this.ipv4Netmask : DEFAULT_IPV4_NETMASK;
            if (ipv4Netmask == null) {
                throw new NullPointerException("Property ipv4Netmask must not be null");
            }
            return new OFBsnInterfaceVer10(hwAddr, name, ipv4Addr, ipv4Netmask);
        }
    }

    static class BuilderWithParent
    implements OFBsnInterface.Builder {
        final OFBsnInterfaceVer10 parentMessage;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean ipv4AddrSet;
        private IPv4Address ipv4Addr;
        private boolean ipv4NetmaskSet;
        private IPv4Address ipv4Netmask;

        BuilderWithParent(OFBsnInterfaceVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFBsnInterface.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFBsnInterface.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Addr() {
            return this.ipv4Addr;
        }

        @Override
        public OFBsnInterface.Builder setIpv4Addr(IPv4Address ipv4Addr) {
            this.ipv4Addr = ipv4Addr;
            this.ipv4AddrSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Netmask() {
            return this.ipv4Netmask;
        }

        @Override
        public OFBsnInterface.Builder setIpv4Netmask(IPv4Address ipv4Netmask) {
            this.ipv4Netmask = ipv4Netmask;
            this.ipv4NetmaskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFBsnInterface build() {
            IPv4Address ipv4Netmask;
            IPv4Address ipv4Addr;
            String name;
            MacAddress hwAddr;
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : this.parentMessage.hwAddr;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            IPv4Address iPv4Address = ipv4Addr = this.ipv4AddrSet ? this.ipv4Addr : this.parentMessage.ipv4Addr;
            if (ipv4Addr == null) {
                throw new NullPointerException("Property ipv4Addr must not be null");
            }
            IPv4Address iPv4Address2 = ipv4Netmask = this.ipv4NetmaskSet ? this.ipv4Netmask : this.parentMessage.ipv4Netmask;
            if (ipv4Netmask == null) {
                throw new NullPointerException("Property ipv4Netmask must not be null");
            }
            return new OFBsnInterfaceVer10(hwAddr, name, ipv4Addr, ipv4Netmask);
        }
    }
}

