/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortStatsEntry;
import org.projectfloodlight.openflow.protocol.OFPortStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver10.OFPortStatsEntryVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFStatsReplyFlagsSerializerVer10;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortStatsReplyVer10
implements OFPortStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatsReplyVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 12;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFPortStatsEntry> DEFAULT_ENTRIES = ImmutableList.of();
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final List<OFPortStatsEntry> entries;
    static final OFPortStatsReplyVer10 DEFAULT = new OFPortStatsReplyVer10(0L, DEFAULT_FLAGS, DEFAULT_ENTRIES);
    static final Reader READER = new Reader();
    static final OFPortStatsReplyVer10Funnel FUNNEL = new OFPortStatsReplyVer10Funnel();
    static final Writer WRITER = new Writer();

    OFPortStatsReplyVer10(long xid, Set<OFStatsReplyFlags> flags, List<OFPortStatsEntry> entries) {
        if (flags == null) {
            throw new NullPointerException("OFPortStatsReplyVer10: property flags cannot be null");
        }
        if (entries == null) {
            throw new NullPointerException("OFPortStatsReplyVer10: property entries cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.entries = entries;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.PORT;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public List<OFPortStatsEntry> getEntries() {
        return this.entries;
    }

    @Override
    public OFPortStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatsReplyVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("entries=").append(this.entries);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatsReplyVer10 other = (OFPortStatsReplyVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortStatsReplyVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortStatsReplyVer10 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(1);
            bb.writeByte(17);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(4);
            OFStatsReplyFlagsSerializerVer10.writeTo(bb, message.flags);
            ChannelUtils.writeList(bb, message.entries);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortStatsReplyVer10Funnel
    implements Funnel<OFPortStatsReplyVer10> {
        private static final long serialVersionUID = 1L;

        OFPortStatsReplyVer10Funnel() {
        }

        public void funnel(OFPortStatsReplyVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)17);
            sink.putLong(message.xid);
            sink.putShort((short)4);
            OFStatsReplyFlagsSerializerVer10.putTo(message.flags, sink);
            FunnelUtils.putList(message.entries, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortStatsReply> {
        Reader() {
        }

        @Override
        public OFPortStatsReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 17) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(17), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 4) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.PORT(4), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer10.readFrom(bb);
            List<OFPortStatsEntry> entries = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFPortStatsEntryVer10.READER);
            OFPortStatsReplyVer10 portStatsReplyVer10 = new OFPortStatsReplyVer10(xid, flags, entries);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portStatsReplyVer10);
            }
            return portStatsReplyVer10;
        }
    }

    static class Builder
    implements OFPortStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean entriesSet;
        private List<OFPortStatsEntry> entries;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.PORT;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFPortStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFPortStatsEntry> getEntries() {
            return this.entries;
        }

        @Override
        public OFPortStatsReply.Builder setEntries(List<OFPortStatsEntry> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFPortStatsReply build() {
            List<OFPortStatsEntry> entries;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List<OFPortStatsEntry> list = entries = this.entriesSet ? this.entries : DEFAULT_ENTRIES;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFPortStatsReplyVer10(xid, flags, entries);
        }
    }

    static class BuilderWithParent
    implements OFPortStatsReply.Builder {
        final OFPortStatsReplyVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean entriesSet;
        private List<OFPortStatsEntry> entries;

        BuilderWithParent(OFPortStatsReplyVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.PORT;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFPortStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFPortStatsEntry> getEntries() {
            return this.entries;
        }

        @Override
        public OFPortStatsReply.Builder setEntries(List<OFPortStatsEntry> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFPortStatsReply build() {
            List entries;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List list = entries = this.entriesSet ? this.entries : this.parentMessage.entries;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFPortStatsReplyVer10(xid, flags, entries);
        }
    }
}

