/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraSetNshc1;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraSetNshc1Ver11
implements OFActionNiciraSetNshc1 {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraSetNshc1Ver11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 16;
    private static final long DEFAULT_NSHC1 = 0L;
    private final long nshc1;
    static final OFActionNiciraSetNshc1Ver11 DEFAULT = new OFActionNiciraSetNshc1Ver11(0L);
    static final Reader READER = new Reader();
    static final OFActionNiciraSetNshc1Ver11Funnel FUNNEL = new OFActionNiciraSetNshc1Ver11Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraSetNshc1Ver11(long nshc1) {
        this.nshc1 = nshc1;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 34;
    }

    @Override
    public long getNshc1() {
        return this.nshc1;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionNiciraSetNshc1.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraSetNshc1Ver11(");
        b.append("nshc1=").append(this.nshc1);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraSetNshc1Ver11 other = (OFActionNiciraSetNshc1Ver11)obj;
        return this.nshc1 == other.nshc1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.nshc1 ^ this.nshc1 >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraSetNshc1Ver11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraSetNshc1Ver11 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(8992);
            bb.writeShort(34);
            bb.writeZero(2);
            bb.writeInt(U32.t(message.nshc1));
        }
    }

    static class OFActionNiciraSetNshc1Ver11Funnel
    implements Funnel<OFActionNiciraSetNshc1Ver11> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraSetNshc1Ver11Funnel() {
        }

        public void funnel(OFActionNiciraSetNshc1Ver11 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(8992);
            sink.putShort((short)34);
            sink.putLong(message.nshc1);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraSetNshc1> {
        Reader() {
        }

        @Override
        public OFActionNiciraSetNshc1 readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 34) {
                throw new OFParseError("Wrong subtype: Expected=0x22(0x22), got=" + subtype);
            }
            bb.skipBytes(2);
            long nshc1 = U32.f(bb.readInt());
            OFActionNiciraSetNshc1Ver11 actionNiciraSetNshc1Ver11 = new OFActionNiciraSetNshc1Ver11(nshc1);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraSetNshc1Ver11);
            }
            return actionNiciraSetNshc1Ver11;
        }
    }

    static class Builder
    implements OFActionNiciraSetNshc1.Builder {
        private boolean nshc1Set;
        private long nshc1;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 34;
        }

        @Override
        public long getNshc1() {
            return this.nshc1;
        }

        @Override
        public OFActionNiciraSetNshc1.Builder setNshc1(long nshc1) {
            this.nshc1 = nshc1;
            this.nshc1Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionNiciraSetNshc1 build() {
            long nshc1 = this.nshc1Set ? this.nshc1 : 0L;
            return new OFActionNiciraSetNshc1Ver11(nshc1);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraSetNshc1.Builder {
        final OFActionNiciraSetNshc1Ver11 parentMessage;
        private boolean nshc1Set;
        private long nshc1;

        BuilderWithParent(OFActionNiciraSetNshc1Ver11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 34;
        }

        @Override
        public long getNshc1() {
            return this.nshc1;
        }

        @Override
        public OFActionNiciraSetNshc1.Builder setNshc1(long nshc1) {
            this.nshc1 = nshc1;
            this.nshc1Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionNiciraSetNshc1 build() {
            long nshc1 = this.nshc1Set ? this.nshc1 : this.parentMessage.nshc1;
            return new OFActionNiciraSetNshc1Ver11(nshc1);
        }
    }
}

